/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.registry;

import de.codecentric.boot.admin.event.ClientApplicationRegisteredEvent;
import de.codecentric.boot.admin.registry.StatusUpdater;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.context.WebApplicationContext;

public class StatusUpdateApplicationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusUpdateApplicationListener.class);
    private final ThreadPoolTaskScheduler taskScheduler;
    private final StatusUpdater statusUpdater;
    private long updatePeriod = 10000L;
    private ScheduledFuture<?> scheduledTask;

    public StatusUpdateApplicationListener(StatusUpdater statusUpdater, ThreadPoolTaskScheduler taskScheduler) {
        this.statusUpdater = statusUpdater;
        this.taskScheduler = taskScheduler;
    }

    @EventListener
    public void onApplicationReady(ApplicationReadyEvent event) {
        if (event.getApplicationContext() instanceof WebApplicationContext) {
            this.startStatusUpdate();
        }
    }

    @EventListener
    public void onContextClosed(ContextClosedEvent event) {
        if (event.getApplicationContext() instanceof WebApplicationContext) {
            this.stopStatusUpdate();
        }
    }

    @EventListener
    public void onClientApplicationRegistered(final ClientApplicationRegisteredEvent event) {
        this.taskScheduler.submit(new Runnable(){

            @Override
            public void run() {
                StatusUpdateApplicationListener.this.statusUpdater.updateStatus(event.getApplication());
            }
        });
    }

    public void startStatusUpdate() {
        if (this.scheduledTask != null && !this.scheduledTask.isDone()) {
            return;
        }
        this.scheduledTask = this.taskScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                StatusUpdateApplicationListener.this.statusUpdater.updateStatusForAllApplications();
            }
        }, this.updatePeriod);
        LOGGER.debug("Scheduled status-updater task for every {}ms", (Object)this.updatePeriod);
    }

    public void stopStatusUpdate() {
        if (this.scheduledTask != null && !this.scheduledTask.isDone()) {
            this.scheduledTask.cancel(true);
            LOGGER.debug("Canceled status-updater task");
        }
    }

    public void setUpdatePeriod(long updatePeriod) {
        this.updatePeriod = updatePeriod;
    }
}

