/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify.filter;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.filter.AbstractNotificationFilter;
import java.time.Instant;
import org.jetbrains.annotations.Nullable;

public abstract class ExpiringNotificationFilter
extends AbstractNotificationFilter {
    @Nullable
    private final Instant expiry;

    public ExpiringNotificationFilter(@Nullable Instant expiry) {
        this.expiry = expiry;
    }

    public boolean isExpired() {
        return this.expiry != null && this.expiry.isBefore(Instant.now());
    }

    @Override
    public boolean filter(InstanceEvent event, Instance instance) {
        return !this.isExpired() && this.doFilter(event, instance);
    }

    protected abstract boolean doFilter(InstanceEvent var1, Instance var2);

    @Nullable
    public Instant getExpiry() {
        return this.expiry;
    }
}

