/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import de.codecentric.boot.admin.actuate.LogfileMvcEndpoint;
import de.codecentric.boot.admin.config.AdminClientProperties;
import de.codecentric.boot.admin.config.AdminProperties;
import de.codecentric.boot.admin.services.SpringBootAdminRegistrator;
import de.codecentric.boot.admin.web.BasicAuthHttpRequestInterceptor;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(value={"spring.boot.admin.url"})
@EnableConfigurationProperties(value={AdminProperties.class, AdminClientProperties.class})
public class SpringBootAdminClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SpringBootAdminRegistrator registrator(AdminProperties adminProps, AdminClientProperties clientProps) {
        return new SpringBootAdminRegistrator(this.createRestTemplate(adminProps), adminProps, clientProps);
    }

    protected RestTemplate createRestTemplate(AdminProperties adminProps) {
        RestTemplate template = new RestTemplate();
        template.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        if (adminProps.getUsername() != null) {
            template.setInterceptors(Arrays.asList(new BasicAuthHttpRequestInterceptor(adminProps.getUsername(), adminProps.getPassword())));
        }
        return template;
    }

    @Bean
    public ScheduledTaskRegistrar taskRegistrar(final SpringBootAdminRegistrator registrator, AdminProperties adminProps) {
        ScheduledTaskRegistrar registrar = new ScheduledTaskRegistrar();
        Runnable registratorTask = new Runnable(){

            @Override
            public void run() {
                registrator.register();
            }
        };
        registrar.addFixedRateTask(registratorTask, (long)adminProps.getPeriod());
        return registrar;
    }

    @Configuration
    @ConditionalOnExpression(value="${endpoints.logfile.enabled:true}")
    @ConditionalOnProperty(value={"logging.file"})
    public static class LogfileEndpointAutoConfiguration {
        @Bean
        public LogfileMvcEndpoint logfileEndpoint() {
            return new LogfileMvcEndpoint();
        }
    }
}

