/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.services;

import de.codecentric.boot.admin.config.AdminClientProperties;
import de.codecentric.boot.admin.config.AdminProperties;
import de.codecentric.boot.admin.model.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class SpringBootAdminRegistrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootAdminRegistrator.class);
    private AdminClientProperties clientProps;
    private AdminProperties adminProps;
    private final RestTemplate template;

    public SpringBootAdminRegistrator(RestTemplate template, AdminProperties adminProps, AdminClientProperties clientProps) {
        this.clientProps = clientProps;
        this.adminProps = adminProps;
        this.template = template;
    }

    public boolean register() {
        Application app = this.createApplication();
        String adminUrl = this.adminProps.getUrl() + '/' + this.adminProps.getContextPath();
        try {
            ResponseEntity response = this.template.postForEntity(adminUrl, (Object)app, Application.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.CREATED)) {
                LOGGER.debug("Application registered itself as {}", response.getBody());
                return true;
            }
            if (response.getStatusCode().equals((Object)HttpStatus.CONFLICT)) {
                LOGGER.warn("Application failed to registered itself as {} because of conflict in registry.", (Object)app);
            } else {
                LOGGER.warn("Application failed to registered itself as {}. Response: {}", (Object)app, (Object)response.toString());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to register application as {} at spring-boot-admin ({}): {}", new Object[]{app, adminUrl, ex.getMessage()});
        }
        return false;
    }

    protected Application createApplication() {
        Application app = new Application(this.clientProps.getUrl(), this.clientProps.getName());
        return app;
    }
}

