/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Application
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String managementUrl;
    private final String healthUrl;
    private final String serviceUrl;

    public Application(String healthUrl, String managementUrl, String serviceUrl, String name) {
        this(healthUrl, managementUrl, serviceUrl, name, null);
    }

    public Application(String healthUrl, String managementUrl, String serviceUrl, String name, String id) {
        this.healthUrl = healthUrl;
        this.managementUrl = managementUrl;
        this.serviceUrl = serviceUrl;
        this.name = name;
        this.id = id;
    }

    @JsonCreator
    public static Application create(@JsonProperty(value="url") String url, @JsonProperty(value="managementUrl") String managementUrl, @JsonProperty(value="healthUrl") String healthUrl, @JsonProperty(value="serviceUrl") String serviceUrl, @JsonProperty(value="name") String name, @JsonProperty(value="id") String id) {
        Assert.hasText((String)name, (String)"name must not be empty!");
        if (StringUtils.hasText((String)url)) {
            return new Application(url.replaceFirst("/+$", "") + "/health", url, null, name, id);
        }
        Assert.hasText((String)healthUrl, (String)"healthUrl must not be empty!");
        return new Application(healthUrl, managementUrl, serviceUrl, name, id);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getManagementUrl() {
        return this.managementUrl;
    }

    public String getHealthUrl() {
        return this.healthUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String toString() {
        return "Application [id=" + this.id + ", name=" + this.name + ", managementUrl=" + this.managementUrl + ", healthUrl=" + this.healthUrl + ", serviceUrl=" + this.serviceUrl + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.healthUrl == null ? 0 : this.healthUrl.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.managementUrl == null ? 0 : this.managementUrl.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.serviceUrl == null ? 0 : this.serviceUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Application other = (Application)obj;
        if (this.healthUrl == null ? other.healthUrl != null : !this.healthUrl.equals(other.healthUrl)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.managementUrl == null ? other.managementUrl != null : !this.managementUrl.equals(other.managementUrl)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.serviceUrl == null ? other.serviceUrl != null : !this.serviceUrl.equals(other.serviceUrl));
    }
}

