/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.boot.admin.client", ignoreUnknownFields=false)
@Order(value=2147483547)
public class AdminClientProperties
implements ApplicationListener<ApplicationEvent> {
    private String managementUrl;
    private String serviceUrl;
    private String healthUrl;
    @Value(value="${spring.application.name:spring-boot-application}")
    private String name;
    @Value(value="${endpoints.health.id:health}")
    private String healthEndpointId;
    private String useIpAddressOf = null;
    @Autowired
    private ManagementServerProperties management;
    @Autowired
    private ServerProperties server;
    private int serverPort = -1;
    private int managementPort = -1;
    private boolean serverInitialized = false;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof EmbeddedServletContainerInitializedEvent) {
            EmbeddedServletContainerInitializedEvent initEvent = (EmbeddedServletContainerInitializedEvent)event;
            this.serverInitialized = true;
            if ("management".equals(initEvent.getApplicationContext().getNamespace())) {
                this.managementPort = initEvent.getEmbeddedServletContainer().getPort();
            } else {
                this.serverPort = initEvent.getEmbeddedServletContainer().getPort();
            }
        } else if (this.startedDeployedWar(event)) {
            this.serverInitialized = true;
            if (!StringUtils.hasText((String)this.serviceUrl)) {
                throw new RuntimeException("spring.boot.admin.client.serviceUrl must be set for deployed war files!");
            }
        }
    }

    private boolean startedDeployedWar(ApplicationEvent event) {
        ApplicationContextEvent contextEvent;
        if (event instanceof ContextRefreshedEvent && (contextEvent = (ApplicationContextEvent)event).getApplicationContext() instanceof EmbeddedWebApplicationContext) {
            EmbeddedWebApplicationContext context = (EmbeddedWebApplicationContext)contextEvent.getApplicationContext();
            return context.getEmbeddedServletContainer() == null;
        }
        return false;
    }

    public String getManagementUrl() {
        if (this.managementUrl == null) {
            if (this.managementPort != -1) {
                return this.createLocalUri(this.managementPort, this.management.getContextPath());
            }
            return this.append(this.getServiceUrl(), this.management.getContextPath());
        }
        return this.managementUrl;
    }

    public void setManagementUrl(String managementUrl) {
        this.managementUrl = managementUrl;
    }

    public String getHealthUrl() {
        if (this.healthUrl == null) {
            return this.append(this.getManagementUrl(), this.healthEndpointId);
        }
        return this.healthUrl;
    }

    public void setHealthUrl(String healthUrl) {
        this.healthUrl = healthUrl;
    }

    public String getServiceUrl() {
        if (this.serviceUrl == null) {
            if (this.serverPort != -1) {
                return this.createLocalUri(this.serverPort, this.server.getContextPath());
            }
            throw new IllegalStateException("EmbeddedServletContainer has not been initialized yet!");
        }
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public boolean isServerInitialized() {
        return this.serverInitialized;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUseIpAddressOf(String useIpAddressOf) {
        this.useIpAddressOf = useIpAddressOf;
    }

    private String createLocalUri(int port, String path) {
        String scheme = this.server.getSsl() != null && this.server.getSsl().isEnabled() ? "https" : "http";
        return this.append(scheme + "://" + this.getHost() + ":" + port, path);
    }

    private String append(String uri, String path) {
        String baseUri = uri.replaceFirst("/+$", "");
        if (StringUtils.isEmpty((Object)path)) {
            return baseUri;
        }
        String normPath = path.replaceFirst("^/+", "").replaceFirst("/+$", "");
        return baseUri + "/" + normPath;
    }

    private String getHost() {
        if (this.useIpAddressOf == null) {
            return this.getHostname();
        }
        return this.getHostIp();
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    private String getHostIp() {
        NetworkInterface nic;
        try {
            nic = NetworkInterface.getByName(this.useIpAddressOf);
        }
        catch (SocketException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        if (nic != null) {
            InetAddress address = this.findIp(nic);
            if (address != null) {
                return address.getHostAddress();
            }
            throw new IllegalStateException("Couldn't determin InetAdress for network interface '" + this.useIpAddressOf + "'");
        }
        throw new IllegalArgumentException("Network interface" + this.useIpAddressOf + " not found! Please specify correct interface for spring.boot.admin.client.useIpAddressOf");
    }

    private InetAddress findIp(NetworkInterface nic) {
        InetAddress candidate = null;
        for (InterfaceAddress address : nic.getInterfaceAddresses()) {
            if (address.getAddress().isLoopbackAddress()) continue;
            if (address.getAddress().isSiteLocalAddress()) {
                return address.getAddress();
            }
            candidate = address.getAddress();
        }
        if (candidate != null) {
            return candidate;
        }
        return null;
    }
}

