/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import de.codecentric.boot.admin.actuate.LogfileMvcEndpoint;
import de.codecentric.boot.admin.config.AdminClientProperties;
import de.codecentric.boot.admin.config.AdminProperties;
import de.codecentric.boot.admin.services.ApplicationRegistrator;
import de.codecentric.boot.admin.services.RegistrationApplicationListener;
import de.codecentric.boot.admin.web.BasicAuthHttpRequestInterceptor;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.web.client.RestTemplate;

@Configuration
public class SpringBootAdminClientAutoConfiguration {

    @Configuration
    @ConditionalOnExpression(value="${endpoints.logfile.enabled:true}")
    @ConditionalOnProperty(value={"logging.file"})
    public static class LogfileEndpointAutoConfiguration {
        @Bean
        public LogfileMvcEndpoint logfileEndpoint() {
            return new LogfileMvcEndpoint();
        }
    }

    @ConditionalOnProperty(value={"spring.boot.admin.url"})
    @EnableConfigurationProperties(value={AdminProperties.class, AdminClientProperties.class})
    public static class AdminClientRegistrationConfig {
        @Bean
        @ConditionalOnMissingBean
        public ApplicationRegistrator registrator(AdminProperties admin, AdminClientProperties client) {
            return new ApplicationRegistrator(this.createRestTemplate(admin), admin, client);
        }

        protected RestTemplate createRestTemplate(AdminProperties admin) {
            RestTemplate template = new RestTemplate();
            template.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
            if (admin.getUsername() != null) {
                template.setInterceptors(Arrays.asList(new BasicAuthHttpRequestInterceptor(admin.getUsername(), admin.getPassword())));
            }
            return template;
        }

        @Bean
        public ScheduledTaskRegistrar taskRegistrar(final ApplicationRegistrator registrator, AdminProperties admin, final AdminClientProperties client) {
            ScheduledTaskRegistrar registrar = new ScheduledTaskRegistrar();
            Runnable registratorTask = new Runnable(){

                @Override
                public void run() {
                    if (client.isServerInitialized()) {
                        registrator.register();
                    }
                }
            };
            registrar.addFixedRateTask(registratorTask, (long)admin.getPeriod());
            return registrar;
        }

        @Bean
        public RegistrationApplicationListener registrationListener(ApplicationRegistrator registrator, AdminProperties admin) {
            return new RegistrationApplicationListener(admin, registrator);
        }
    }
}

