/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.services;

import de.codecentric.boot.admin.config.AdminProperties;
import de.codecentric.boot.admin.services.ApplicationRegistrator;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.Order;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;

@Order(value=0x7FFFFFFF)
public class RegistrationApplicationListener
implements ApplicationListener<ApplicationEvent> {
    private final AdminProperties admin;
    private final ApplicationRegistrator registrator;
    private final TaskExecutor executor;

    public RegistrationApplicationListener(AdminProperties admin, ApplicationRegistrator registrator, TaskExecutor executor) {
        this.admin = admin;
        this.registrator = registrator;
        this.executor = executor;
    }

    public RegistrationApplicationListener(AdminProperties admin, ApplicationRegistrator registrator) {
        this(admin, registrator, (TaskExecutor)new SimpleAsyncTaskExecutor());
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.startedDeployedWar(event) || this.startedEmbeddedServer(event)) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    RegistrationApplicationListener.this.registrator.register();
                }
            });
        } else if (this.admin.isAutoDeregistration() && event instanceof ContextClosedEvent) {
            this.registrator.deregister();
        }
    }

    private boolean startedEmbeddedServer(ApplicationEvent event) {
        return event instanceof EmbeddedServletContainerInitializedEvent;
    }

    private boolean startedDeployedWar(ApplicationEvent event) {
        ApplicationContextEvent contextEvent;
        if (event instanceof ContextRefreshedEvent && (contextEvent = (ApplicationContextEvent)event).getApplicationContext() instanceof EmbeddedWebApplicationContext) {
            EmbeddedWebApplicationContext context = (EmbeddedWebApplicationContext)contextEvent.getApplicationContext();
            return context.getEmbeddedServletContainer() == null;
        }
        return false;
    }
}

