/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.event.EventListener;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

@ConfigurationProperties(prefix="spring.boot.admin.client")
public class AdminClientProperties {
    private String managementUrl;
    private String serviceUrl;
    private String healthUrl;
    @Value(value="${spring.application.name:spring-boot-application}")
    private String name;
    private boolean preferIp = false;
    @Value(value="${endpoints.health.path:/${endpoints.health.id:health}}")
    private String healthEndpointPath;
    @Autowired
    private ManagementServerProperties management;
    @Autowired
    private ServerProperties server;
    private Integer serverPort;
    private Integer managementPort;

    @EventListener
    public void onApplicationReady(ApplicationReadyEvent event) {
        this.serverPort = (Integer)event.getApplicationContext().getEnvironment().getProperty("local.server.port", Integer.class);
        this.managementPort = (Integer)event.getApplicationContext().getEnvironment().getProperty("local.management.port", Integer.class, (Object)this.serverPort);
    }

    public String getServiceUrl() {
        if (this.serviceUrl != null) {
            return this.serviceUrl;
        }
        if (this.serverPort == null) {
            throw new IllegalStateException("serviceUrl must be set when deployed to servlet-container");
        }
        return UriComponentsBuilder.newInstance().scheme(this.getScheme()).host(this.getServiceHost()).port(this.serverPort.intValue()).path(this.server.getContextPath()).toUriString();
    }

    public String getManagementUrl() {
        if (this.managementUrl != null) {
            return this.managementUrl;
        }
        if (this.managementPort == null || this.managementPort.equals(this.serverPort)) {
            return UriComponentsBuilder.fromHttpUrl((String)this.getServiceUrl()).pathSegment(this.server.getServletPrefix().split("/")).pathSegment(StringUtils.trimLeadingCharacter((String)this.management.getContextPath(), (char)'/').split("/")).toUriString();
        }
        return UriComponentsBuilder.newInstance().scheme(this.getScheme()).host(this.getManagementHost()).port(this.managementPort.intValue()).path(this.management.getContextPath()).toUriString();
    }

    public String getHealthUrl() {
        if (this.healthUrl != null) {
            return this.healthUrl;
        }
        return UriComponentsBuilder.fromHttpUrl((String)this.getManagementUrl()).pathSegment(StringUtils.trimLeadingCharacter((String)this.healthEndpointPath, (char)'/').split("/")).toUriString();
    }

    public void setManagementUrl(String managementUrl) {
        this.managementUrl = managementUrl;
    }

    public void setHealthUrl(String healthUrl) {
        this.healthUrl = healthUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPreferIp(boolean preferIp) {
        this.preferIp = preferIp;
    }

    public boolean isPreferIp() {
        return this.preferIp;
    }

    private String getScheme() {
        return this.server.getSsl() != null && this.server.getSsl().isEnabled() ? "https" : "http";
    }

    private String getHost(InetAddress address) {
        return this.preferIp ? address.getHostAddress() : address.getCanonicalHostName();
    }

    private String getServiceHost() {
        InetAddress address = this.server.getAddress();
        if (address == null) {
            address = this.getLocalHost();
        }
        return this.getHost(address);
    }

    private String getManagementHost() {
        InetAddress address = this.management.getAddress();
        if (address != null) {
            return this.getHost(address);
        }
        return this.getServiceHost();
    }

    private InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }
}

