/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import de.codecentric.boot.admin.config.AdminClientProperties;
import de.codecentric.boot.admin.config.AdminProperties;
import de.codecentric.boot.admin.config.SpringBootAdminClientEnabledCondition;
import de.codecentric.boot.admin.services.ApplicationRegistrator;
import de.codecentric.boot.admin.services.RegistrationApplicationListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@EnableConfigurationProperties(value={AdminProperties.class, AdminClientProperties.class})
@Conditional(value={SpringBootAdminClientEnabledCondition.class})
public class SpringBootAdminClientAutoConfiguration {
    @Autowired
    private AdminClientProperties client;
    @Autowired
    private AdminProperties admin;
    @Autowired
    private RestTemplateBuilder restTemplBuilder;

    @Bean
    @ConditionalOnMissingBean
    public ApplicationRegistrator registrator() {
        RestTemplateBuilder builder = this.restTemplBuilder.messageConverters(new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter()}).requestFactory(SimpleClientHttpRequestFactory.class);
        if (this.admin.getUsername() != null) {
            builder = builder.basicAuthorization(this.admin.getUsername(), this.admin.getPassword());
        }
        return new ApplicationRegistrator(builder.build(), this.admin, this.client);
    }

    @Bean
    @Qualifier(value="registrationTaskScheduler")
    public TaskScheduler registrationTaskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(1);
        taskScheduler.setRemoveOnCancelPolicy(true);
        taskScheduler.setThreadNamePrefix("registrationTask");
        return taskScheduler;
    }

    @Bean
    @ConditionalOnMissingBean
    public RegistrationApplicationListener registrationListener() {
        RegistrationApplicationListener listener = new RegistrationApplicationListener(this.registrator(), this.registrationTaskScheduler());
        listener.setAutoRegister(this.admin.isAutoRegistration());
        listener.setAutoDeregister(this.admin.isAutoDeregistration());
        listener.setRegisterPeriod(this.admin.getPeriod());
        return listener;
    }
}

