/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import de.codecentric.boot.admin.actuate.LogfileMvcEndpoint;
import de.codecentric.boot.admin.config.AdminClientProperties;
import de.codecentric.boot.admin.config.AdminProperties;
import de.codecentric.boot.admin.services.SpringBootAdminRegistrator;
import de.codecentric.boot.admin.web.BasicAuthHttpRequestInterceptor;
import de.codecentric.boot.admin.web.EndpointCorsFilter;
import de.codecentric.boot.admin.web.EndpointCorsInterceptor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.mvc.JolokiaMvcEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.mvc.ServletWrappingController;

@Configuration
@ConditionalOnProperty(value={"spring.boot.admin.url"})
@EnableConfigurationProperties(value={AdminProperties.class, AdminClientProperties.class})
public class SpringBootAdminClientAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean
    public SpringBootAdminRegistrator registrator(AdminProperties adminProps, AdminClientProperties clientProps) {
        return new SpringBootAdminRegistrator(this.createRestTemplate(adminProps), adminProps, clientProps);
    }

    protected RestTemplate createRestTemplate(AdminProperties adminProps) {
        RestTemplate template = new RestTemplate();
        template.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        if (adminProps.getUsername() != null) {
            template.setInterceptors(Arrays.asList(new BasicAuthHttpRequestInterceptor(adminProps.getUsername(), adminProps.getPassword())));
        }
        return template;
    }

    @Bean
    public ScheduledTaskRegistrar taskRegistrar(final SpringBootAdminRegistrator registrator, AdminProperties adminProps) {
        ScheduledTaskRegistrar registrar = new ScheduledTaskRegistrar();
        Runnable registratorTask = new Runnable(){

            @Override
            public void run() {
                registrator.register();
            }
        };
        registrar.addFixedRateTask(registratorTask, (long)adminProps.getPeriod());
        return registrar;
    }

    @Bean
    @ConditionalOnMissingBean
    public EndpointCorsFilter endpointCorsFilter(EndpointHandlerMapping endpointHandlerMapping) {
        return new EndpointCorsFilter(endpointHandlerMapping);
    }

    @Bean
    public ApplicationListener<EmbeddedServletContainerInitializedEvent> appListener() {
        return new ApplicationListener<EmbeddedServletContainerInitializedEvent>(){

            public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
                if ("management".equals(event.getApplicationContext().getNamespace())) {
                    for (EndpointHandlerMapping handlerMapping : event.getApplicationContext().getBeansOfType(EndpointHandlerMapping.class).values()) {
                        try {
                            Field interceptorsField = AbstractHandlerMapping.class.getDeclaredField("adaptedInterceptors");
                            interceptorsField.setAccessible(true);
                            List adaptedInterceptors = (List)interceptorsField.get(handlerMapping);
                            EndpointCorsInterceptor interceptor = new EndpointCorsInterceptor();
                            event.getApplicationContext().getBeanFactory().autowireBean((Object)interceptor);
                            adaptedInterceptors.add(interceptor);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("Couldn't add handlerInterceptor for cors", ex);
                        }
                    }
                    for (DispatcherServlet servlet : event.getApplicationContext().getBeansOfType(DispatcherServlet.class).values()) {
                        servlet.setDispatchOptionsRequest(true);
                    }
                    for (JolokiaMvcEndpoint jolokiaMvcEndpoint : SpringBootAdminClientAutoConfiguration.this.applicationContext.getBeansOfType(JolokiaMvcEndpoint.class).values()) {
                        try {
                            Field controllerField = JolokiaMvcEndpoint.class.getDeclaredField("controller");
                            ReflectionUtils.makeAccessible((Field)controllerField);
                            ServletWrappingController controller = (ServletWrappingController)controllerField.get(jolokiaMvcEndpoint);
                            controller.setSupportedMethods(new String[]{"GET", "HEAD", "POST", "OPTIONS"});
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("Couldn't reconfigure servletWrappingController for Jolokia", ex);
                        }
                    }
                }
            }
        };
    }

    @Configuration
    @ConditionalOnExpression(value="${endpoints.logfile.enabled:true}")
    @ConditionalOnProperty(value={"logging.file"})
    public static class LogfileEndpointAutoConfiguration {
        @Bean
        public LogfileMvcEndpoint logfileEndpoint() {
            return new LogfileMvcEndpoint();
        }
    }
}

