/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class EndpointCorsInterceptor
extends HandlerInterceptorAdapter {
    @Value(value="${http.filter.cors.origin:*}")
    private String origin;
    @Value(value="${http.filter.cors.headers:Origin, X-Requested-With, Content-Type, Accept}")
    private String headers;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        response.setHeader("Access-Control-Allow-Origin", this.origin);
        response.setHeader("Access-Control-Allow-Headers", this.headers);
        return super.preHandle(request, response, handler);
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }
}

