/*
 * Decompiled with CFR 0.152.
 */
package de.congrace.exp4j;

import de.congrace.exp4j.CalculationToken;
import de.congrace.exp4j.Token;
import java.util.Map;
import java.util.Stack;

class NumberToken
extends CalculationToken {
    private final double doubleValue;

    NumberToken(String value) {
        super(value);
        if (value.indexOf(69) > 0 || value.indexOf(101) > 0) {
            value = value.toLowerCase();
            int pos = value.indexOf(101);
            double mantissa = Double.parseDouble(value.substring(0, pos));
            double exponent = Double.parseDouble(value.substring(pos + 1));
            this.doubleValue = mantissa * Math.pow(10.0, exponent);
        } else {
            this.doubleValue = Double.parseDouble(value);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof NumberToken) {
            NumberToken t = (NumberToken)obj;
            return t.getValue().equals(this.getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    void mutateStackForCalculation(Stack<Double> stack, Map<String, Double> variableValues) {
        stack.push(this.doubleValue);
    }

    @Override
    void mutateStackForInfixTranslation(Stack<Token> operatorStack, StringBuilder output) {
        output.append(this.getValue()).append(' ');
    }
}

