/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.postgres.snapshot.util;

import de.cronn.postgres.snapshot.util.ConnectionInformation;
import de.cronn.postgres.snapshot.util.PostgresDumpFormat;
import de.cronn.postgres.snapshot.util.PostgresDumpOption;
import de.cronn.postgres.snapshot.util.PostgresUtils;
import de.cronn.postgres.snapshot.util.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.startupcheck.OneShotStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.utility.ThrowingFunction;

public final class PostgresDump {
    private static final Logger log = LoggerFactory.getLogger(PostgresDump.class);
    public static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final String CONTAINER_DUMP_FILE = "/tmp/pg_dump.data";

    private PostgresDump() {
    }

    public static String dumpToString(String jdbcUrl, String username, String password, PostgresDumpOption ... options) {
        return PostgresDump.dumpToString(jdbcUrl, username, password, List.of(), options);
    }

    public static String dumpToString(String jdbcUrl, String username, String password, List<Schema> schemas, PostgresDumpOption ... options) {
        return PostgresDump.dumpToString(jdbcUrl, username, password, schemas, List.of(), options);
    }

    public static String dumpToString(String jdbcUrl, String username, String password, List<Schema> schemas, List<String> excludeTableDataPatterns, PostgresDumpOption ... options) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            PostgresDump.dump((Writer)writer, jdbcUrl, username, password, schemas, excludeTableDataPatterns, options);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        writer.close();
        return string;
    }

    public static void dumpToFile(Path path, String jdbcUrl, String username, String password, PostgresDumpFormat format, PostgresDumpOption ... options) {
        PostgresDump.dumpToFile(path, jdbcUrl, username, password, format, List.of(), options);
    }

    public static void dumpToFile(Path path, String jdbcUrl, String username, String password, PostgresDumpFormat format, List<Schema> schemas, PostgresDumpOption ... options) {
        PostgresDump.dumpToFile(path, jdbcUrl, username, password, format, schemas, List.of(), options);
    }

    public static void dumpToFile(Path path, String jdbcUrl, String username, String password, PostgresDumpFormat format, List<Schema> schemas, List<String> excludeTableDataPatterns, PostgresDumpOption ... options) {
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            PostgresDump.dump(outputStream, jdbcUrl, username, password, format, schemas, excludeTableDataPatterns, options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void dump(Writer writer, String jdbcUrl, String username, String password, PostgresDumpOption ... options) {
        PostgresDump.dump(writer, jdbcUrl, username, password, List.of(), options);
    }

    public static void dump(Writer writer, String jdbcUrl, String username, String password, List<Schema> schemas, PostgresDumpOption ... options) {
        PostgresDump.dump(writer, jdbcUrl, username, password, schemas, List.of(), options);
    }

    public static void dump(Writer writer, String jdbcUrl, String username, String password, List<Schema> schemas, List<String> excludeTableDataPatterns, PostgresDumpOption ... options) {
        PostgresDump.dump(jdbcUrl, username, password, PostgresDumpFormat.PLAIN_TEXT, schemas, excludeTableDataPatterns, (ThrowingFunction<InputStream, Long>)((ThrowingFunction)inputStream -> {
            try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, ENCODING);){
                Long l = inputStreamReader.transferTo(writer);
                return l;
            }
        }), options);
    }

    public static void dump(OutputStream outputStream, String jdbcUrl, String username, String password, PostgresDumpFormat format, PostgresDumpOption ... options) {
        PostgresDump.dump(outputStream, jdbcUrl, username, password, format, List.of(), options);
    }

    public static void dump(OutputStream outputStream, String jdbcUrl, String username, String password, PostgresDumpFormat format, List<Schema> schemas, PostgresDumpOption ... options) {
        PostgresDump.dump(outputStream, jdbcUrl, username, password, format, schemas, List.of(), options);
    }

    public static void dump(OutputStream outputStream, String jdbcUrl, String username, String password, PostgresDumpFormat format, List<Schema> schemas, List<String> excludeTableDataPatterns, PostgresDumpOption ... options) {
        PostgresDump.dump(jdbcUrl, username, password, format, schemas, excludeTableDataPatterns, (ThrowingFunction<InputStream, Long>)((ThrowingFunction)inputStream -> inputStream.transferTo(outputStream)), options);
    }

    private static void dump(String jdbcUrl, String username, String password, PostgresDumpFormat format, List<Schema> schemas, List<String> excludeTableDataPatterns, ThrowingFunction<InputStream, Long> inputStreamProcessor, PostgresDumpOption ... options) {
        try (GenericContainer<?> container = PostgresDump.createPgDumpInContainer(jdbcUrl, username, password, format, schemas, excludeTableDataPatterns, options);){
            container.start();
            container.copyFileFromContainer(CONTAINER_DUMP_FILE, inputStreamProcessor);
        }
    }

    private static GenericContainer<?> createPgDumpInContainer(String jdbcUrl, String username, String password, PostgresDumpFormat format, List<Schema> schemas, List<String> excludeTableDataPatterns, PostgresDumpOption ... options) {
        ConnectionInformation connectionInformation = PostgresUtils.parseConnectionInformation(jdbcUrl, username, password);
        CharSequence[] command = PostgresDump.createPgDumpCommand(connectionInformation, format, schemas, excludeTableDataPatterns, options);
        log.debug("Executing {}", (Object)String.join((CharSequence)" ", command));
        Slf4jLogConsumer logConsumer = new Slf4jLogConsumer(log).withSeparateOutputStreams();
        return PostgresUtils.createPostgresContainer(connectionInformation.postgresVersion()).withNetworkMode(PostgresUtils.deriveNetworkMode(connectionInformation)).withEnv("PGPASSWORD", connectionInformation.password()).withStartupCheckStrategy((StartupCheckStrategy)new OneShotStartupCheckStrategy()).withCommand((String[])command).withLogConsumer((Consumer)logConsumer);
    }

    private static String[] createPgDumpCommand(ConnectionInformation connectionInformation, PostgresDumpFormat format, List<Schema> schemas, List<String> excludeTableDataPatterns, PostgresDumpOption ... options) {
        ArrayList<CallSite> commandArgs = new ArrayList<CallSite>(List.of("pg_dump", "--host=" + connectionInformation.host(), "--username=" + connectionInformation.username(), "--dbname=" + connectionInformation.databaseName(), "--format=" + format.getCommandArgument(), "--file=/tmp/pg_dump.data", "--encoding=" + ENCODING.name()));
        if (connectionInformation.port() > 0) {
            commandArgs.add(2, (CallSite)((Object)("--port=" + connectionInformation.port())));
        }
        for (Schema schema : schemas) {
            commandArgs.addAll(schema.getCommandArguments());
        }
        for (String excludeTableDataPattern : excludeTableDataPatterns) {
            commandArgs.add((CallSite)((Object)("--exclude-table-data=" + excludeTableDataPattern)));
        }
        for (Iterator<Object> iterator : options) {
            commandArgs.add((CallSite)((Object)((PostgresDumpOption)((Object)iterator)).getCommandArgument()));
        }
        return (String[])commandArgs.toArray(String[]::new);
    }
}

