/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.reflection.util.immutable;

import de.cronn.reflection.util.ClassUtils;
import de.cronn.reflection.util.PropertyUtils;
import de.cronn.reflection.util.immutable.GenericImmutableProxyForwarder;
import de.cronn.reflection.util.immutable.Immutable;
import de.cronn.reflection.util.immutable.ImmutableProxyForwarderBoolean;
import de.cronn.reflection.util.immutable.ImmutableProxyForwarderInteger;
import de.cronn.reflection.util.immutable.ImmutableProxyForwarderLong;
import de.cronn.reflection.util.immutable.ImmutableProxyForwarderString;
import de.cronn.reflection.util.immutable.ReadOnly;
import de.cronn.reflection.util.immutable.collection.DeepImmutableCollection;
import de.cronn.reflection.util.immutable.collection.DeepImmutableList;
import de.cronn.reflection.util.immutable.collection.DeepImmutableMap;
import de.cronn.reflection.util.immutable.collection.DeepImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.implementation.ExceptionMethod;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.objenesis.ObjenesisHelper;

public final class ImmutableProxy {
    static final String DELEGATE_FIELD_NAME = "$delegate";
    private static final Map<Class<?>, Class<?>> immutableProxyClassCache = new ConcurrentHashMap();

    private ImmutableProxy() {
    }

    public static <T> T create(T instance) {
        if (ImmutableProxy.isImmutable(instance)) {
            return instance;
        }
        Class<T> proxyClass = ImmutableProxy.getOrCreateProxyClass(instance);
        Object proxy = ObjenesisHelper.newInstance(proxyClass);
        PropertyUtils.writeDirectly(proxy, DELEGATE_FIELD_NAME, instance);
        return (T)proxy;
    }

    public static <T> Collection<T> create(Collection<T> collection) {
        return new DeepImmutableCollection<T>(collection);
    }

    public static <T> List<T> create(List<T> list) {
        return new DeepImmutableList<T>(list);
    }

    public static <T> Set<T> create(Set<T> set) {
        return new DeepImmutableSet<T>(set);
    }

    public static <K, V> Map<K, V> create(Map<K, V> map) {
        return new DeepImmutableMap<K, V>(map);
    }

    public static <T> T unwrap(T immutableProxy) {
        if (!ImmutableProxy.isImmutableProxy(immutableProxy)) {
            return immutableProxy;
        }
        return PropertyUtils.readDirectly(immutableProxy, DELEGATE_FIELD_NAME);
    }

    static boolean isImmutable(Object value) {
        if (value == null) {
            return true;
        }
        if (ImmutableProxy.isImmutableProxy(value)) {
            return true;
        }
        if (value instanceof String) {
            return true;
        }
        if (value instanceof Number) {
            return true;
        }
        if (value instanceof Boolean) {
            return true;
        }
        if (value instanceof Character) {
            return true;
        }
        if (value instanceof Temporal) {
            return true;
        }
        if (value instanceof TemporalAmount) {
            return true;
        }
        return ImmutableProxy.isEnumValue(value);
    }

    private static boolean isEnumValue(Object value) {
        return value.getClass().isEnum() || value.getClass().getSuperclass() != null && value.getClass().getSuperclass().isEnum();
    }

    private static <T> Class<? extends T> getOrCreateProxyClass(T instance) {
        Class<T> realClass = ClassUtils.getRealClass(instance);
        return immutableProxyClassCache.computeIfAbsent(realClass, clazz -> ImmutableProxy.createProxyClass(clazz));
    }

    private static <T> Class<? extends T> createProxyClass(Class<T> clazz) {
        return new ByteBuddy().subclass(clazz).implement(new Type[]{Immutable.class}).defineField(DELEGATE_FIELD_NAME, clazz, new ModifierContributor.ForField[0]).method((ElementMatcher)ElementMatchers.any()).intercept(ExceptionMethod.throwing(UnsupportedOperationException.class, (String)("This instance is immutable. Annotate the method with @" + ReadOnly.class.getSimpleName() + " if this is a false-positive."))).method(ImmutableProxy.isReadyOnlyMethod()).intercept((Implementation)MethodDelegation.to(GenericImmutableProxyForwarder.class)).method((ElementMatcher)ImmutableProxy.isReadyOnlyMethod().and((ElementMatcher)ElementMatchers.returns(Long.class).or((ElementMatcher)ElementMatchers.returns(Long.TYPE)))).intercept((Implementation)MethodDelegation.to(ImmutableProxyForwarderLong.class)).method((ElementMatcher)ImmutableProxy.isReadyOnlyMethod().and((ElementMatcher)ElementMatchers.returns(Integer.class).or((ElementMatcher)ElementMatchers.returns(Integer.TYPE)))).intercept((Implementation)MethodDelegation.to(ImmutableProxyForwarderInteger.class)).method((ElementMatcher)ImmutableProxy.isReadyOnlyMethod().and((ElementMatcher)ElementMatchers.returns(Boolean.class).or((ElementMatcher)ElementMatchers.returns(Boolean.TYPE)))).intercept((Implementation)MethodDelegation.to(ImmutableProxyForwarderBoolean.class)).method((ElementMatcher)ImmutableProxy.isReadyOnlyMethod().and((ElementMatcher)ElementMatchers.returns(String.class))).intercept((Implementation)MethodDelegation.to(ImmutableProxyForwarderString.class)).make().load(ImmutableProxy.class.getClassLoader()).getLoaded();
    }

    private static ElementMatcher.Junction<MethodDescription> isReadyOnlyMethod() {
        return ElementMatchers.not((ElementMatcher)ElementMatchers.isSetter()).and((ElementMatcher)ElementMatchers.isGetter().or((ElementMatcher)ElementMatchers.isHashCode()).or((ElementMatcher)ElementMatchers.isEquals()).or((ElementMatcher)ElementMatchers.isToString()).or((ElementMatcher)ElementMatchers.isClone()).or((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class)).or(ImmutableProxy.isAnnotatedWith(ReadOnly.class)));
    }

    private static ElementMatcher<MethodDescription> isAnnotatedWith(Class<? extends Annotation> annotation) {
        return target -> {
            TypeDefinition type = target.getDeclaringType();
            MethodDescription.SignatureToken methodSignature = target.asSignatureToken();
            return ImmutableProxy.isAnnotatedWith(methodSignature, type, annotation);
        };
    }

    private static boolean isAnnotatedWith(MethodDescription.SignatureToken methodSignature, TypeDefinition type, Class<? extends Annotation> annotation) {
        if (type == null || type.equals(TypeDescription.OBJECT)) {
            return false;
        }
        if (ImmutableProxy.hasMethodAnnotatedWith(methodSignature, type, annotation)) {
            return true;
        }
        TypeList.Generic interfaces = type.getInterfaces();
        for (TypeDefinition interfaceType : interfaces) {
            if (ImmutableProxy.hasMethodAnnotatedWith(methodSignature, interfaceType, annotation)) {
                return true;
            }
            for (TypeDescription.Generic interfaceSuperclass : interfaceType.getInterfaces()) {
                if (!ImmutableProxy.isAnnotatedWith(methodSignature, (TypeDefinition)interfaceSuperclass, annotation)) continue;
                return true;
            }
        }
        return ImmutableProxy.isAnnotatedWith(methodSignature, (TypeDefinition)type.getSuperClass(), annotation);
    }

    private static boolean hasMethodAnnotatedWith(MethodDescription.SignatureToken methodSignature, TypeDefinition type, Class<? extends Annotation> annotation) {
        return !((MethodList)type.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.hasMethodName((String)methodSignature.getName()).and((ElementMatcher)ElementMatchers.takesArguments((Iterable)methodSignature.getParameterTypes())).and((ElementMatcher)ElementMatchers.isAnnotatedWith(annotation)))).isEmpty();
    }

    public static boolean isImmutableProxy(Object object) {
        if (object == null) {
            return false;
        }
        return ImmutableProxy.isImmutableProxyClass(object.getClass());
    }

    public static boolean isImmutableProxyClass(Class<?> beanClass) {
        return Immutable.class.isAssignableFrom(beanClass);
    }

    static void clearCache() {
        immutableProxyClassCache.clear();
    }
}

