/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.testutils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JUnit5MisusageCheck
implements BeforeAllCallback {
    public void beforeAll(ExtensionContext context) throws Exception {
        Class clazz = context.getRequiredTestClass();
        List<Class<?>> topDownHierarchy = this.getTopDownHierarchy(clazz);
        ArrayList<Method> nonCompliantMethods = new ArrayList<Method>();
        for (Class annotation : Arrays.asList(BeforeEach.class, Test.class, AfterEach.class)) {
            nonCompliantMethods.addAll(this.checkInstanceMethodMisusage(topDownHierarchy, annotation));
        }
        for (Class annotation : Arrays.asList(BeforeAll.class, AfterAll.class)) {
            nonCompliantMethods.addAll(this.checkStaticMethodMisusage(topDownHierarchy, annotation));
        }
        if (!nonCompliantMethods.isEmpty()) {
            throw new IllegalStateException(nonCompliantMethods.stream().map(Method::toString).collect(Collectors.joining("\n", "Misused junit5 callback methods: \n", "")));
        }
    }

    private List<Method> checkInstanceMethodMisusage(List<Class<?>> topDownHierarchy, Class<? extends Annotation> annotation) {
        ArrayList<Method> misusedMethods = new ArrayList<Method>();
        ArrayList<Method> annotatedMethodsFromAncestors = new ArrayList<Method>();
        for (Class<?> clazz : topDownHierarchy) {
            List<Method> clazzInstanceMethods = this.getDeclaredInstanceMethods(clazz);
            for (Method overriddenMethod : this.findOverriddenMethods(annotatedMethodsFromAncestors, clazzInstanceMethods)) {
                if (overriddenMethod.getAnnotation(annotation) != null) continue;
                misusedMethods.add(overriddenMethod);
            }
            annotatedMethodsFromAncestors.addAll(this.getAnnotatedMethods(annotation, clazzInstanceMethods));
        }
        return misusedMethods;
    }

    private List<Method> getDeclaredInstanceMethods(Class<?> clazz) {
        return Stream.of(clazz.getDeclaredMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).collect(Collectors.toList());
    }

    private List<Method> findOverriddenMethods(List<Method> ancestorMethods, List<Method> methodsToCheck) {
        ArrayList<Method> overriddenMethods = new ArrayList<Method>();
        for (Method methodToCheck : methodsToCheck) {
            for (Method ancestorMethod : ancestorMethods) {
                if (!this.isInstanceMethodOverridden(methodToCheck, ancestorMethod)) continue;
                overriddenMethods.add(methodToCheck);
            }
        }
        return overriddenMethods;
    }

    private List<Method> checkStaticMethodMisusage(List<Class<?>> topDownHierarchy, Class<? extends Annotation> annotation) {
        ArrayList<Method> misusedMethods = new ArrayList<Method>();
        ArrayList<Method> annotatedMethodsFromAncestors = new ArrayList<Method>();
        for (Class<?> clazz : topDownHierarchy) {
            List<Method> clazzDeclaredStaticMethods = this.getDeclaredStaticMethods(clazz);
            misusedMethods.addAll(this.findHiddenMethods(annotatedMethodsFromAncestors, clazzDeclaredStaticMethods));
            annotatedMethodsFromAncestors.addAll(this.getAnnotatedMethods(annotation, clazzDeclaredStaticMethods));
        }
        return misusedMethods;
    }

    private List<Method> getDeclaredStaticMethods(Class<?> clazz) {
        return Stream.of(clazz.getDeclaredMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).collect(Collectors.toList());
    }

    private List<Method> findHiddenMethods(List<Method> ancestorMethods, List<Method> methodsToCheck) {
        ArrayList<Method> hiddenMethods = new ArrayList<Method>();
        for (Method methodToCheck : methodsToCheck) {
            for (Method ancestorMethod : ancestorMethods) {
                if (!this.isStaticMethodHidden(methodToCheck, ancestorMethod)) continue;
                hiddenMethods.add(methodToCheck);
            }
        }
        return hiddenMethods;
    }

    private List<Method> getAnnotatedMethods(Class<? extends Annotation> annotation, List<Method> methods) {
        return methods.stream().filter(method -> method.getAnnotation(annotation) != null).collect(Collectors.toList());
    }

    private boolean isInstanceMethodOverridden(Method childMethod, Method parentMethod) {
        boolean namesMatch = childMethod.getName().equals(parentMethod.getName());
        boolean parameterTypesMatch = Arrays.equals(childMethod.getParameterTypes(), parentMethod.getParameterTypes());
        boolean returnTypesMatch = parentMethod.getReturnType().isAssignableFrom(childMethod.getReturnType());
        return namesMatch && parameterTypesMatch && returnTypesMatch;
    }

    private boolean isStaticMethodHidden(Method childMethod, Method parentMethod) {
        boolean namesMatch = childMethod.getName().equals(parentMethod.getName());
        boolean parameterTypesMatch = Arrays.equals(childMethod.getParameterTypes(), parentMethod.getParameterTypes());
        return namesMatch && parameterTypesMatch;
    }

    private List<Class<?>> getTopDownHierarchy(Class<?> clazz) {
        ArrayList bottomUpHierarchy = new ArrayList();
        bottomUpHierarchy.add(clazz);
        while (clazz.getSuperclass() != Object.class) {
            clazz = clazz.getSuperclass();
            bottomUpHierarchy.add(clazz);
        }
        Collections.reverse(bottomUpHierarchy);
        return bottomUpHierarchy;
    }
}

