/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.testutils.h2;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TableGenerator;
import javax.persistence.metamodel.EntityType;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class H2Util {
    private static final Logger log = LoggerFactory.getLogger(H2Util.class);
    private static final String H2_JDBC_DRIVER = "H2 JDBC Driver";
    private static final Map<Class<?>, List<TableGenerator>> TABLE_GENERATORS = new LinkedHashMap();
    @Autowired(required=false)
    private EntityManager entityManager;
    @Autowired(required=false)
    private DataSource dataSource;

    public void resetDatabase() {
        if (this.dataSource != null) {
            Set<String> sequenceTableNames = this.collectSequenceTableNames();
            try {
                H2Util.cleanupEmbeddedDatabase(this.dataSource, sequenceTableNames);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void dropAllObjects() {
        if (this.dataSource != null) {
            try {
                H2Util.dropAllObjects(this.dataSource);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Set<String> collectSequenceTableNames() {
        if (this.entityManager == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> sequenceTableNames = new LinkedHashSet<String>();
        for (EntityType entityType : this.entityManager.getMetamodel().getEntities()) {
            Class entityJavaType = entityType.getJavaType();
            for (TableGenerator entry : TABLE_GENERATORS.computeIfAbsent(entityJavaType, H2Util::getTableGeneratorAnnotations)) {
                if ("".equals(entry.table())) {
                    throw new UnsupportedOperationException("Empty TableGenerator table name is not supported. Please specify table name explicitly");
                }
                sequenceTableNames.add(entry.table());
            }
        }
        return sequenceTableNames;
    }

    private static List<TableGenerator> getTableGeneratorAnnotations(Class<?> type) {
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        H2Util.collectFields(type, fields);
        return fields.stream().filter(f -> f.isAnnotationPresent(TableGenerator.class)).map(f -> f.getAnnotation(TableGenerator.class)).collect(Collectors.toList());
    }

    private static void collectFields(Class<?> type, Collection<Field> collectedFields) {
        Class<?> superclass;
        collectedFields.addAll(Arrays.asList(type.getFields()));
        collectedFields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (!type.equals(Object.class) && (superclass = type.getSuperclass()) != null) {
            H2Util.collectFields(superclass, collectedFields);
        }
    }

    private static void cleanupEmbeddedDatabase(DataSource dataSource, Set<String> sequenceTableNames) throws Exception {
        try (Connection connection = dataSource.getConnection();){
            H2Util.assertIsH2Database(connection);
            H2Util.truncateAllTables(connection, sequenceTableNames);
            H2Util.resetAllSequences(connection);
        }
    }

    private static void dropAllObjects(DataSource dataSource) throws Exception {
        try (Connection connection = dataSource.getConnection();){
            H2Util.assertIsH2Database(connection);
            H2Util.dropAllObjects(connection);
        }
    }

    private static void resetAllSequences(Connection connection) throws Exception {
        ArrayList<String> sequenceNames = new ArrayList<String>();
        try (PreparedStatement stmt = connection.prepareStatement("SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SEQUENCES WHERE CURRENT_VALUE > 0");
             ResultSet resultSet = stmt.executeQuery();){
            while (resultSet.next()) {
                String sequenceName = resultSet.getString("SEQUENCE_NAME");
                sequenceNames.add(sequenceName);
            }
        }
        for (String sequenceName : sequenceNames) {
            H2Util.executeStatement(connection, "ALTER SEQUENCE " + sequenceName + " RESTART WITH 1");
        }
    }

    private static void dropAllObjects(Connection connection) throws Exception {
        H2Util.executeStatement(connection, "DROP ALL OBJECTS");
    }

    private static void truncateAllTables(Connection connection, Set<String> sequencesTableNames) throws Exception {
        H2Util.executeStatement(connection, "SET REFERENTIAL_INTEGRITY FALSE");
        Set<String> lowerCaseSequencesTableNames = H2Util.collectInLowerCase(sequencesTableNames);
        Set<String> tableNames = H2Util.getTableNames(connection);
        for (String tableName : tableNames) {
            long count = H2Util.selectCount(connection, tableName);
            if (count <= 0L) continue;
            if (lowerCaseSequencesTableNames.contains(tableName.toLowerCase())) {
                log.warn("resetting {} sequences in table '{}'", (Object)count, (Object)tableName);
                H2Util.executeStatement(connection, "UPDATE " + tableName + " SET next_val = 0");
                continue;
            }
            log.warn("deleting {} rows from table '{}'", (Object)count, (Object)tableName);
            H2Util.executeStatement(connection, "TRUNCATE TABLE " + tableName);
        }
        H2Util.executeStatement(connection, "SET REFERENTIAL_INTEGRITY TRUE");
    }

    private static Set<String> collectInLowerCase(Set<String> sequencesTableNames) {
        return sequencesTableNames.stream().map(String::toLowerCase).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    /*
     * Exception decompiling
     */
    private static long selectCount(Connection connection, String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Set<String> getTableNames(Connection con) throws SQLException {
        String[] tableTypes = new String[]{"TABLE"};
        LinkedHashSet<String> tableNames = new LinkedHashSet<String>();
        try (ResultSet tables = con.getMetaData().getTables(null, null, null, tableTypes);){
            while (tables.next()) {
                String tableName = tables.getString("TABLE_NAME");
                tableNames.add(tableName);
            }
        }
        return tableNames;
    }

    private static void assertIsH2Database(Connection connection) throws SQLException {
        String driverName = connection.getMetaData().getDriverName();
        Assert.state((boolean)H2_JDBC_DRIVER.equals(driverName), (String)("Unexpected driver: " + driverName));
    }

    private static void executeStatement(Connection connection, String sql) throws Exception {
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.execute();
        }
    }
}

