/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.testutils;

import de.cronn.testutils.ExecutorServiceUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class ConcurrentTest<T> {
    private static final int TIMEOUT_MILLIS = 30000;
    private int concurrencyLevel = 10;
    private final IndexedCallable<T> task;
    private String threadNamePrefix = ConcurrentTest.class.getSimpleName();

    public ConcurrentTest(IndexedCallable<T> task) {
        this.task = task;
    }

    public static <T> ConcurrentTest<T> create(IndexedCallable<T> task) {
        return new ConcurrentTest<T>(task);
    }

    public ConcurrentTest<T> withConcurrencyLevel(int concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
        return this;
    }

    public ConcurrentTest<T> withThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
        return this;
    }

    public ConcurrentTest<T> withThreadNamePrefixFromClass(Class<?> clazz) {
        return this.withThreadNamePrefix(clazz.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAndAssertEachResult(Consumer<T> assertion) throws InterruptedException, ExecutionException {
        NamedThreadFactory threadFactory = new NamedThreadFactory(this.threadNamePrefix);
        ExecutorService executorService = Executors.newFixedThreadPool(this.concurrencyLevel, threadFactory);
        try {
            int i;
            ExecutorCompletionService<T> completionService = new ExecutorCompletionService<T>(executorService);
            for (i = 0; i < this.concurrencyLevel; ++i) {
                completionService.submit(this.task.toCallable(i));
            }
            for (i = 0; i < this.concurrencyLevel; ++i) {
                Object result = completionService.take().get();
                assertion.accept(result);
            }
        }
        finally {
            ExecutorServiceUtils.shutdownOrThrow(executorService, this.threadNamePrefix, 30000L);
        }
    }

    @FunctionalInterface
    public static interface IndexedCallable<T> {
        public T call(int var1) throws Exception;

        default public Callable<T> toCallable(int index) {
            return () -> this.call(index);
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final String prefix;
        private final AtomicInteger threadCount = new AtomicInteger();

        public NamedThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.prefix + this.threadCount.incrementAndGet());
        }
    }
}

