/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.testutils;

import de.cronn.testutils.ExecutorServiceUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class ExecutorServiceExtension
implements BeforeEachCallback,
AfterEachCallback {
    private final Duration testTimeout;
    private ExecutorService executorService;
    private List<Future<?>> futures;

    public ExecutorServiceExtension(long testTimeoutMillis) {
        this(Duration.ofMillis(testTimeoutMillis));
    }

    public ExecutorServiceExtension(Duration testTimeout) {
        this.testTimeout = testTimeout;
    }

    public void afterEach(ExtensionContext context) {
        ExecutorServiceUtils.shutdownOrThrow(this.executorService, this.getTestName(context), this.testTimeout);
    }

    public void beforeEach(ExtensionContext context) {
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory(this.getTestName(context));
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)threadFactory);
        this.futures = new ArrayList();
    }

    private String getTestName(ExtensionContext context) {
        return TestNameUtils.getTestName(context.getRequiredTestClass(), context.getRequiredTestMethod().getName());
    }

    public Future<Void> submit(Runnable runnable) {
        return this.submit(() -> {
            runnable.run();
            return null;
        });
    }

    public <T> Future<T> submit(Callable<T> callable) {
        Future<T> future = this.executorService.submit(callable);
        this.futures.add(future);
        return future;
    }

    public List<Future<?>> getFutures() {
        return this.futures;
    }

    public void awaitAllFutures() throws Exception {
        for (Future<?> future : this.getFutures()) {
            future.get();
        }
    }

    static class TestNameUtils {
        private TestNameUtils() {
        }

        public static String getTestName(Class<?> aClass, String methodName) {
            return TestNameUtils.join(TestNameUtils.enclosingClassesUpstream(aClass), methodName);
        }

        private static String enclosingClassesUpstream(Class<?> aClass) {
            String classHierarchy = aClass.getSimpleName();
            for (Class<?> enclosingClass = aClass.getEnclosingClass(); enclosingClass != null; enclosingClass = enclosingClass.getEnclosingClass()) {
                classHierarchy = TestNameUtils.join(enclosingClass.getSimpleName(), classHierarchy);
            }
            return classHierarchy;
        }

        private static String join(String element, String other) {
            return other.startsWith("_") ? element + other : element + "_" + other;
        }
    }
}

