/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.testutils;

import de.cronn.testutils.TestUtilsRuntimeException;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorServiceUtils {
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceUtils.class);

    private ExecutorServiceUtils() {
    }

    public static void shutdownOrThrow(ExecutorService executor, String executorServiceName, long timeoutMillis) {
        ExecutorServiceUtils.shutdownOrThrow(executor, executorServiceName, Duration.ofMillis(timeoutMillis));
    }

    public static void shutdownOrThrow(ExecutorService executor, String executorServiceName, Duration timeout) {
        if (executor != null) {
            try {
                if (!ExecutorServiceUtils.shutdownGracefully(executor, executorServiceName, timeout)) {
                    boolean success = ExecutorServiceUtils.shutdownNow(executor, executorServiceName, timeout);
                    Assertions.assertTrue((boolean)success, (String)String.format("Failed to shutdown %s", executorServiceName));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TestUtilsRuntimeException("Failed to shutdown " + executorServiceName);
            }
        }
    }

    public static boolean shutdownNow(ExecutorService executorService, String executorServiceName, long timeoutMillis) throws InterruptedException {
        return ExecutorServiceUtils.shutdownNow(executorService, executorServiceName, Duration.ofMillis(timeoutMillis));
    }

    public static boolean shutdownNow(ExecutorService executorService, String executorServiceName, Duration timeout) throws InterruptedException {
        return ExecutorServiceUtils.shutdown(executorService, executorServiceName, timeout, true);
    }

    public static boolean shutdownGracefully(ExecutorService executorService, String executorServiceName, long timeoutMillis) throws InterruptedException {
        return ExecutorServiceUtils.shutdownGracefully(executorService, executorServiceName, Duration.ofMillis(timeoutMillis));
    }

    public static boolean shutdownGracefully(ExecutorService executorService, String executorServiceName, Duration timeout) throws InterruptedException {
        return ExecutorServiceUtils.shutdown(executorService, executorServiceName, timeout, false);
    }

    private static boolean shutdown(ExecutorService executorService, String executorServiceName, Duration timeout, boolean shutdownWithInterrupt) throws InterruptedException {
        return ExecutorServiceUtils.shutdown(executorService, executorServiceName, timeout.toMillis(), shutdownWithInterrupt);
    }

    private static boolean shutdown(ExecutorService executorService, String executorServiceName, long timeoutMillis, boolean shutdownWithInterrupt) throws InterruptedException {
        log.debug("Shutting down {}", (Object)executorServiceName);
        if (shutdownWithInterrupt) {
            executorService.shutdownNow();
        } else {
            executorService.shutdown();
        }
        ExecutorServiceUtils.clearQueue(executorService, executorServiceName);
        boolean success = executorService.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
        if (success) {
            log.info("Finished shutdown of '{}'", (Object)executorServiceName);
        } else if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            log.warn("Shutdown of '{}' timed out after {} ms. Active tasks: {}", new Object[]{executorServiceName, timeoutMillis, threadPoolExecutor.getActiveCount()});
        } else {
            log.warn("Shutdown of '{}' timed out after {} ms.", (Object)executorServiceName, (Object)timeoutMillis);
        }
        return success;
    }

    private static void clearQueue(ExecutorService executorService, String executorServiceName) {
        ThreadPoolExecutor threadPoolExecutor;
        BlockingQueue<Runnable> queue;
        if (executorService instanceof ThreadPoolExecutor && !(queue = (threadPoolExecutor = (ThreadPoolExecutor)executorService).getQueue()).isEmpty()) {
            int queueSize = queue.size();
            log.warn("Clearing approximately {} elements from queue of '{}'", (Object)queueSize, (Object)executorServiceName);
            queue.clear();
        }
    }
}

