/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.testutils;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClock
extends Clock {
    public static final Instant DEFAULT_TEST_INSTANT = Instant.parse("2016-01-01T00:00:00.123456Z");
    private static final Logger log = LoggerFactory.getLogger(TestClock.class);
    private final AtomicReference<Instant> instant;
    private final ZoneId zone;

    public TestClock() {
        this(DEFAULT_TEST_INSTANT, ZoneOffset.UTC);
    }

    public TestClock(Instant instant, ZoneId zone) {
        this.instant = new AtomicReference<Instant>(instant);
        this.zone = zone;
    }

    public TestClock(String instant, String zone) {
        this(Instant.parse(instant), ZoneId.of(zone));
    }

    @Override
    public Instant instant() {
        return this.instant.get();
    }

    public ZonedDateTime now() {
        return ZonedDateTime.ofInstant(this.instant(), this.zone);
    }

    public LocalDate today() {
        return LocalDate.now(this);
    }

    public void changeInstant(Instant instant) {
        this.instant.set(instant);
        log.info("Setting test time to {}", (Object)instant);
    }

    public void reset() {
        this.changeInstant(DEFAULT_TEST_INSTANT);
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        Objects.requireNonNull(zone);
        if (zone.equals(this.zone)) {
            return this;
        }
        return new TestClock(this.instant.get(), this.zone);
    }

    public Instant windForward(Duration duration) {
        if (duration.isNegative()) {
            throw new IllegalArgumentException(String.format("Cannot wind clock *forward* by a negative duration: %s", duration));
        }
        Instant newInstant = this.instant.updateAndGet(i -> i.plus(duration));
        log.info("Winding test time forward to {}", (Object)newInstant);
        return newInstant;
    }

    public void windForwardSeconds(int seconds) {
        this.windForward(Duration.ofSeconds(seconds));
    }

    public void windForwardHours(long hours) {
        this.windForward(Duration.ofHours(hours));
    }

    public void windForwardDays(long days) {
        this.windForward(Duration.ofDays(days));
    }

    public void windForwardToDate(LocalDate targetDate) {
        LocalDate oldDate = this.today();
        long daysToWindForward = ChronoUnit.DAYS.between(oldDate, targetDate);
        if (daysToWindForward < 0L) {
            Instant targetInstant = this.instant().plus(Duration.ofDays(daysToWindForward));
            throw new IllegalArgumentException(String.format("Cannot wind clock(now=%s) *forward* to date in past(%s)", this.instant(), targetInstant));
        }
        if (daysToWindForward > 0L) {
            this.windForwardDays(daysToWindForward);
        } else {
            Assertions.assertEquals((Object)targetDate, (Object)oldDate, (String)String.format("%s must be equal to %s", targetDate, oldDate));
            log.info("Keeping test time at {}", (Object)this.instant());
        }
    }

    public void windBack(Duration duration) {
        if (duration.isNegative()) {
            throw new IllegalArgumentException(String.format("Cannot wind clock *backward* by a negative duration: %s", duration));
        }
        Instant newInstant = this.instant.updateAndGet(i -> i.minus(duration));
        log.info("Winding test time back to {}", (Object)newInstant);
    }

    public void windBackSeconds(long seconds) {
        this.windBack(Duration.ofSeconds(seconds));
    }

    public void windBackHours(long hours) {
        this.windBack(Duration.ofHours(hours));
    }

    public void windBackDays(long days) {
        this.windBack(Duration.ofDays(days));
    }

    public void windBackToDate(LocalDate targetDate) {
        LocalDate oldDate = this.today();
        long daysToWindBackward = ChronoUnit.DAYS.between(targetDate, oldDate);
        if (daysToWindBackward < 0L) {
            Instant targetInstant = this.instant().minus(Duration.ofDays(daysToWindBackward));
            throw new IllegalArgumentException(String.format("Cannot wind clock(now=%s) *backward* to date in the future(%s)", this.instant(), targetInstant));
        }
        if (daysToWindBackward > 0L) {
            this.windBackDays(daysToWindBackward);
        } else {
            Assertions.assertEquals((Object)targetDate, (Object)oldDate, (String)String.format("%s must be equal to %s", targetDate, oldDate));
            log.info("Keeping test time at {}", (Object)this.instant());
        }
    }

    public static TestClock defaultBerlin() {
        return new TestClock(DEFAULT_TEST_INSTANT, ZoneId.of("Europe/Berlin"));
    }

    public static TestClock defaultUtc() {
        return new TestClock(DEFAULT_TEST_INSTANT, ZoneOffset.UTC);
    }
}

