/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.testutils;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TestInfoExtension
implements BeforeEachCallback,
TestInfo {
    private String displayName;
    private Set<String> tags;
    private Class<?> testClass;
    private Method testMethod;

    public void beforeEach(ExtensionContext context) {
        this.displayName = context.getDisplayName();
        this.tags = context.getTags();
        this.testClass = context.getTestClass().orElse(null);
        this.testMethod = context.getTestMethod().orElse(null);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Optional<Class<?>> getTestClass() {
        return Optional.ofNullable(this.testClass);
    }

    public Optional<Method> getTestMethod() {
        return Optional.ofNullable(this.testMethod);
    }
}

