/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.testutils;

import de.cronn.testutils.ThreadLeakException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.ThreadUtils;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLeakCheck
implements BeforeAllCallback,
AfterAllCallback {
    private static final Logger log = LoggerFactory.getLogger(ThreadLeakCheck.class);
    private static final Duration THREAD_SHUTDOWN_GRACE_PERIOD = Duration.ofMillis(500L);
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ThreadLeakCheck.class});

    public void beforeAll(ExtensionContext context) {
        if (this.store(context).get((Object)Keys.EXTENDED_TEST_CLASS) == null) {
            if (context.getParent().orElse(null) != context.getRoot()) {
                throw new IllegalStateException("Extension has to be registered at top class level");
            }
            this.store(context).put((Object)Keys.EXTENDED_TEST_CLASS, (Object)context.getRequiredTestClass());
            this.store(context).put((Object)Keys.THREADS_BEFORE_TEST, ThreadLeakCheck.getAllLivingThreadNamesById());
        }
    }

    public void afterAll(ExtensionContext context) {
        Class extendedClass = (Class)this.store(context).get((Object)Keys.EXTENDED_TEST_CLASS);
        if (context.getRequiredTestClass().equals(extendedClass)) {
            LinkedHashSet<String> allowedThreadNames = new LinkedHashSet<String>();
            LinkedHashSet<String> allowedThreadNamePrefixes = new LinkedHashSet<String>();
            for (Class clazz = extendedClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                AllowedThreads allowedThreads = clazz.getAnnotation(AllowedThreads.class);
                if (allowedThreads == null) continue;
                allowedThreadNames.addAll(Arrays.asList(allowedThreads.names()));
                allowedThreadNamePrefixes.addAll(Arrays.asList(allowedThreads.prefixes()));
            }
            Map threadsBeforeTest = (Map)this.store(context).get((Object)Keys.THREADS_BEFORE_TEST);
            Map<Long, Thread> threadsAfterTest = ThreadLeakCheck.getAllLivingThreadNamesById();
            threadsAfterTest.keySet().removeAll(threadsBeforeTest.keySet());
            threadsAfterTest.values().removeIf(thread -> allowedThreadNames.contains(thread.getName()));
            threadsAfterTest.values().removeIf(this.threadNameStartsWithAny(allowedThreadNamePrefixes));
            threadsAfterTest.values().removeIf(this::checkIfThreadTerminatesAfterGracePeriod);
            threadsAfterTest.values().removeIf(this::isAddressChangeListenerThread);
            threadsAfterTest.values().removeIf(this::isIocpEventHandlerTask);
            if (!threadsAfterTest.isEmpty()) {
                throw new ThreadLeakException("Potential thread leak detected. Running threads after test that did not exist before: " + threadsAfterTest.values().stream().map(thread -> "'" + thread.getName() + "' (state: " + thread.getState() + ", interrupted: " + thread.isInterrupted() + ")").collect(Collectors.joining(", ")));
            }
        }
    }

    private boolean checkIfThreadTerminatesAfterGracePeriod(Thread thread) {
        log.warn("Giving {} in state {} {} to shut down", new Object[]{thread, thread.getState(), THREAD_SHUTDOWN_GRACE_PERIOD});
        try {
            thread.join(THREAD_SHUTDOWN_GRACE_PERIOD.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Interrupted: ", (Throwable)e);
            return false;
        }
        if (thread.isAlive()) {
            log.error("{} is still alive! Stack trace: \n\t\t{}", (Object)thread, (Object)Arrays.stream(thread.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n\t\t")));
            return false;
        }
        log.info("{} finished", (Object)thread);
        return true;
    }

    private boolean isAddressChangeListenerThread(Thread thread) {
        if (SystemUtils.IS_OS_WINDOWS && thread.getName().startsWith("Thread-")) {
            return ThreadLeakCheck.stackTraceContainsClassName(thread, "sun.net.dns.ResolverConfigurationImpl$AddressChangeListener");
        }
        return false;
    }

    private boolean isIocpEventHandlerTask(Thread thread) {
        if (SystemUtils.IS_OS_WINDOWS && thread.getName().startsWith("Thread-")) {
            return ThreadLeakCheck.stackTraceContainsClassName(thread, "sun.nio.ch.Iocp$EventHandlerTask");
        }
        return false;
    }

    private static boolean stackTraceContainsClassName(Thread thread, String className) {
        return Arrays.stream(thread.getStackTrace()).anyMatch(stackTraceElement -> className.equals(stackTraceElement.getClassName()));
    }

    private static Map<Long, Thread> getAllLivingThreadNamesById() {
        return ThreadUtils.getAllThreads().stream().filter(Objects::nonNull).filter(Thread::isAlive).sorted(Comparator.comparingLong(Thread::getId)).collect(Collectors.toMap(Thread::getId, thread -> thread, (t, t2) -> {
            throw new IllegalStateException();
        }, LinkedHashMap::new));
    }

    private Predicate<Thread> threadNameStartsWithAny(Collection<String> prefixes) {
        return thread -> {
            for (String prefix : prefixes) {
                if (!thread.getName().startsWith(prefix)) continue;
                return true;
            }
            return false;
        };
    }

    private ExtensionContext.Store store(ExtensionContext context) {
        return context.getStore(NAMESPACE);
    }

    static enum Keys {
        THREADS_BEFORE_TEST,
        EXTENDED_TEST_CLASS;

    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface AllowedThreads {
        public String[] prefixes() default {};

        public String[] names() default {};
    }
}

