/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.testutils.spring;

import de.cronn.testutils.TestClock;
import java.time.Clock;
import java.util.function.Function;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.junit.jupiter.SpringExtension;

public class ResetClockExtension
implements AfterAllCallback,
AfterEachCallback {
    private final Function<ExtensionContext, Boolean> resetAfter;

    public ResetClockExtension(Function<ExtensionContext, Boolean> resetAfter) {
        this.resetAfter = resetAfter;
    }

    public ResetClockExtension() {
        this(context -> !ResetClockExtension.hasDeclaredMethodOrder(context));
    }

    public void afterEach(ExtensionContext context) {
        if (this.resetAfter.apply(context).booleanValue()) {
            this.resetClock(context);
        }
    }

    public void afterAll(ExtensionContext context) {
        this.resetClock(context);
    }

    public static boolean hasDeclaredMethodOrder(ExtensionContext context) {
        TestMethodOrder annotation = context.getRequiredTestClass().getAnnotation(TestMethodOrder.class);
        return annotation != null && annotation.value() != MethodOrderer.Random.class;
    }

    protected void resetClock(ExtensionContext context) {
        ApplicationContext applicationContext = SpringExtension.getApplicationContext((ExtensionContext)context);
        Clock clock = (Clock)applicationContext.getBean(Clock.class);
        if (clock instanceof TestClock) {
            TestClock testClock = (TestClock)clock;
            testClock.reset();
        }
    }
}

