/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.assertions.validationfile;

import difflib.DiffUtils;
import difflib.Patch;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opentest4j.AssertionFailedError;

public class FileBasedComparisonFailure
extends AssertionFailedError {
    private static final long serialVersionUID = 1L;
    private final String fExpected;
    private final String fActual;

    public FileBasedComparisonFailure(String expected, String actual, String filenameExpected, String filenameActual) {
        super(FileBasedComparisonFailure.buildDiff(expected, actual, filenameExpected, filenameActual), (Object)expected, (Object)actual);
        this.fExpected = expected;
        this.fActual = actual;
    }

    private static String buildDiff(String expected, String actual, String filenameExpected, String filenameActual) {
        List<Object> actualLines;
        List<Object> expectedLines = expected == null ? Collections.emptyList() : FileBasedComparisonFailure.splitLines(expected);
        Patch patch = DiffUtils.diff(expectedLines, actualLines = actual == null ? Collections.emptyList() : FileBasedComparisonFailure.splitLines(actual));
        List deltas = patch.getDeltas();
        if (deltas.isEmpty()) {
            throw new IllegalArgumentException("expected and actual values are equal");
        }
        return "\n" + String.join((CharSequence)"\n", DiffUtils.generateUnifiedDiff((String)("expected" + (filenameExpected != null ? "/" + filenameExpected : "")), (String)("actual" + (filenameActual != null ? "/" + filenameActual : "")), expectedLines, (Patch)patch, (int)3));
    }

    private static List<String> splitLines(String textToSplit) {
        return Arrays.asList(textToSplit.split("\n"));
    }
}

