/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.assertions.validationfile;

import de.cronn.assertions.validationfile.FileExtension;
import de.cronn.assertions.validationfile.FileExtensions;
import de.cronn.assertions.validationfile.normalization.ValidationNormalizer;
import de.cronn.assertions.validationfile.util.FileBasedComparisonUtils;
import java.util.concurrent.Callable;

public interface ValidationFileAssertions {
    public String getTestName();

    default public String getValidationFileName(String baseName, FileExtension extension) {
        return baseName + "." + extension.asString();
    }

    default public String getValidationFileName(String baseName, String suffix, FileExtension extension) {
        if (suffix == null || suffix.isEmpty()) {
            return this.getValidationFileName(baseName, extension);
        }
        return this.getValidationFileName(baseName + "_" + suffix, extension);
    }

    default public FailedAssertionHandler failedAssertionHandler() {
        return null;
    }

    default public void assertWithFile(String actualOutput, String filename, ValidationNormalizer normalizer) {
        FailedAssertionHandler failedAssertionsCollector = this.failedAssertionHandler();
        if (failedAssertionsCollector != null) {
            failedAssertionsCollector.executeAndHandleFailedAssertion(() -> {
                FileBasedComparisonUtils.compareActualWithFileHidden(actualOutput, filename, normalizer);
                return null;
            });
        } else {
            FileBasedComparisonUtils.compareActualWithFileHidden(actualOutput, filename, normalizer);
        }
    }

    default public void assertWithFile(String actualString, FileExtension extension) {
        this.assertWithFile(actualString, this.getValidationFileName(this.getTestName(), extension), null);
    }

    default public void assertWithFileWithSuffix(String actualString, String suffix, FileExtension extension) {
        this.assertWithFileWithSuffix(actualString, null, suffix, extension);
    }

    default public void assertWithFileWithSuffix(String actualString, ValidationNormalizer validationNormalizer, String suffix, FileExtension extension) {
        this.assertWithFile(actualString, this.getValidationFileName(this.getTestName(), suffix, extension), validationNormalizer);
    }

    default public void assertWithFile(String actualOutput, ValidationNormalizer validationNormalizer, FileExtension extension) {
        this.assertWithFile(actualOutput, this.getValidationFileName(this.getTestName(), extension), validationNormalizer);
    }

    default public void assertWithFile(String actualString) {
        this.assertWithFile(actualString, FileExtensions.TXT);
    }

    default public void assertWithFileWithSuffix(String actualString, String suffix) {
        this.assertWithFileWithSuffix(actualString, suffix, FileExtensions.TXT);
    }

    default public void assertWithFileWithSuffix(String actualString, ValidationNormalizer validationNormalizer, String suffix) {
        this.assertWithFileWithSuffix(actualString, validationNormalizer, suffix, FileExtensions.TXT);
    }

    default public void assertWithFile(String actualOutput, ValidationNormalizer validationNormalizer) {
        this.assertWithFile(actualOutput, validationNormalizer, FileExtensions.TXT);
    }

    default public void assertWithJsonFile(String actualJsonString) {
        this.assertWithFile(actualJsonString, FileExtensions.JSON);
    }

    default public void assertWithJsonFileWithSuffix(String actualJsonString, String suffix) {
        this.assertWithFileWithSuffix(actualJsonString, suffix, FileExtensions.JSON);
    }

    default public void assertWithJsonFileWithSuffix(String actualJsonString, ValidationNormalizer validationNormalizer, String suffix) {
        this.assertWithFileWithSuffix(actualJsonString, validationNormalizer, suffix, FileExtensions.JSON);
    }

    default public void assertWithJsonFile(String actualJsonString, ValidationNormalizer validationNormalizer) {
        this.assertWithFile(actualJsonString, validationNormalizer, FileExtensions.JSON);
    }

    default public void assertWithJson5File(String actualJsonString) {
        this.assertWithFile(actualJsonString, FileExtensions.JSON5);
    }

    default public void assertWithJson5FileWithSuffix(String actualJsonString, String suffix) {
        this.assertWithFileWithSuffix(actualJsonString, suffix, FileExtensions.JSON5);
    }

    default public void assertWithJson5FileWithSuffix(String actualJsonString, ValidationNormalizer validationNormalizer, String suffix) {
        this.assertWithFileWithSuffix(actualJsonString, validationNormalizer, suffix, FileExtensions.JSON5);
    }

    default public void assertWithJson5File(String actualJsonString, ValidationNormalizer validationNormalizer) {
        this.assertWithFile(actualJsonString, validationNormalizer, FileExtensions.JSON5);
    }

    default public void assertWithYamlFile(String actualJsonString) {
        this.assertWithFile(actualJsonString, FileExtensions.YAML);
    }

    default public void assertWithYamlFileWithSuffix(String actualJsonString, String suffix) {
        this.assertWithFileWithSuffix(actualJsonString, suffix, FileExtensions.YAML);
    }

    default public void assertWithYamlFileWithSuffix(String actualJsonString, ValidationNormalizer validationNormalizer, String suffix) {
        this.assertWithFileWithSuffix(actualJsonString, validationNormalizer, suffix, FileExtensions.YAML);
    }

    default public void assertWithYamlFile(String actualJsonString, ValidationNormalizer validationNormalizer) {
        this.assertWithFile(actualJsonString, validationNormalizer, FileExtensions.YAML);
    }

    default public void assertWithXmlFile(String actualXmlString) {
        this.assertWithFile(actualXmlString, FileExtensions.XML);
    }

    default public void assertWithXmlFileWithSuffix(String actualXmlString, String suffix) {
        this.assertWithFileWithSuffix(actualXmlString, suffix, FileExtensions.XML);
    }

    default public void assertWithXmlFileWithSuffix(String actualXmlString, ValidationNormalizer validationNormalizer, String suffix) {
        this.assertWithFileWithSuffix(actualXmlString, validationNormalizer, suffix, FileExtensions.XML);
    }

    default public void assertWithXmlFile(String actualXmlString, ValidationNormalizer validationNormalizer) {
        this.assertWithFile(actualXmlString, validationNormalizer, FileExtensions.XML);
    }

    public static interface FailedAssertionHandler {
        public void executeAndHandleFailedAssertion(Callable<Void> var1);
    }
}

