/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.assertions.validationfile.normalization;

import de.cronn.assertions.validationfile.normalization.IdProvider;
import de.cronn.assertions.validationfile.normalization.IncrementingIdProvider;
import de.cronn.assertions.validationfile.normalization.ValidationNormalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdNormalizer
implements ValidationNormalizer {
    private static final String BACKSLASH = "\\\\";
    public static final String ESCAPED_STRING = "(?:[^\\\\]|\\\\.)+?";
    private final boolean doIdMapping;
    private final Collection<Pattern> patterns;
    private final Map<String, String> idMap = new HashMap<String, String>();
    private final IdProvider idProvider;
    private final String idPrefix;

    public IdNormalizer(String ... regexp) {
        this((IdProvider)new IncrementingIdProvider(), "", true, regexp);
    }

    public IdNormalizer(IdProvider idProvider, String idPrefix, String ... regularExpressions) {
        this(idProvider, idPrefix, true, regularExpressions);
    }

    public IdNormalizer(IdProvider idProvider, String idPrefix, boolean doIdMapping, String ... regularExpressions) {
        this.doIdMapping = doIdMapping;
        this.idProvider = idProvider;
        this.idPrefix = idPrefix;
        this.patterns = new ArrayList<Pattern>();
        for (String regularExpression : regularExpressions) {
            Pattern pattern = Pattern.compile(regularExpression);
            this.patterns.add(pattern);
        }
    }

    @Override
    public String normalize(String input) {
        String result = input;
        for (Pattern pattern : this.patterns) {
            result = this.normalizeOnePattern(result, pattern);
        }
        return result;
    }

    private String normalizeOnePattern(String input, Pattern pattern) {
        Matcher m = pattern.matcher(input);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String id = m.group(1);
            String newIdAsString = this.lookupNewIdAsString(id);
            String stringBeforeGroup = input.substring(m.start(), m.start(1));
            String stringAfterGroup = input.substring(m.end(1), m.end());
            String replacement = stringBeforeGroup + this.idPrefix + newIdAsString + stringAfterGroup;
            String escapedReplacement = replacement.replace("\\", BACKSLASH);
            escapedReplacement = escapedReplacement.replace("$", "\\$");
            m.appendReplacement(result, escapedReplacement);
        }
        m.appendTail(result);
        return result.toString();
    }

    private String lookupNewIdAsString(String originalId) {
        String newIdAsString = null;
        if (this.doIdMapping) {
            newIdAsString = this.idMap.get(originalId);
        }
        if (newIdAsString == null) {
            long newId = this.idProvider.next();
            newIdAsString = String.valueOf(newId);
            if (this.doIdMapping) {
                this.idMap.put(originalId, newIdAsString);
            }
        }
        return newIdAsString;
    }
}

