/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.assertions.validationfile.normalization;

import de.cronn.assertions.validationfile.normalization.ValidationNormalizer;
import java.util.Objects;

public class SimpleRegexReplacement
implements ValidationNormalizer {
    private String regex;
    private String replacement;

    public SimpleRegexReplacement(String regex, String replacement) {
        Objects.requireNonNull(regex);
        this.regex = regex;
        this.replacement = replacement;
    }

    public SimpleRegexReplacement(String regex) {
        this(regex, "[masked]");
    }

    public String apply(String source) {
        return source.replaceAll(this.regex, this.replacement);
    }

    public String getRegex() {
        return this.regex;
    }

    public String getReplacement() {
        return this.replacement;
    }

    @Override
    public String normalize(String source) {
        return this.apply(source);
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }
}

