/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.assertions.validationfile.normalization;

import java.util.Arrays;
import java.util.Collection;

@FunctionalInterface
public interface ValidationNormalizer {
    public String normalize(String var1);

    default public ValidationNormalizer and(ValidationNormalizer otherNormalizer) {
        return ValidationNormalizer.combine(this, otherNormalizer);
    }

    public static ValidationNormalizer doNothing() {
        return s -> s;
    }

    public static ValidationNormalizer combine(ValidationNormalizer ... normalizers) {
        return ValidationNormalizer.combine(Arrays.asList(normalizers));
    }

    public static ValidationNormalizer combine(Collection<ValidationNormalizer> normalizers) {
        return s -> ValidationNormalizer.applyNormalizers(s, normalizers);
    }

    public static String applyNormalizers(String input, Collection<ValidationNormalizer> normalizers) {
        String normalized = input;
        for (ValidationNormalizer validationNormalizer : normalizers) {
            normalized = validationNormalizer.normalize(normalized);
        }
        return normalized;
    }
}

