/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.assertions.validationfile.replacements;

import de.cronn.assertions.validationfile.normalization.ValidationNormalizer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractXmlReplacerBuilder<T extends AbstractXmlReplacerBuilder<?>> {
    private String namespace;
    private String elementName;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();

    protected abstract T getThis();

    protected abstract ValidationNormalizer build(String var1, String var2);

    public T withNamespace(String namespace) {
        this.namespace = namespace;
        return this.getThis();
    }

    public T withElementName(String attribute) {
        this.elementName = attribute;
        return this.getThis();
    }

    public T withAttribute(String name, String value) {
        this.attributes.put(name, value);
        return this.getThis();
    }

    String createEndTag() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("</");
        if (this.namespace != null) {
            stringBuilder.append(this.namespace).append(":");
        }
        stringBuilder.append(this.elementName);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    String createStartTag() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        if (this.namespace != null) {
            stringBuilder.append(this.namespace).append(":");
        }
        stringBuilder.append(this.elementName);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            String attributeName = entry.getKey();
            stringBuilder.append(" ");
            stringBuilder.append(attributeName);
            String attributeValue = entry.getValue();
            if (attributeValue == null) continue;
            stringBuilder.append("=\"");
            stringBuilder.append(attributeValue);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public final ValidationNormalizer build() {
        Objects.requireNonNull(this.elementName);
        String startTag = this.createStartTag();
        String endTag = this.createEndTag();
        return this.build(startTag, endTag);
    }
}

