/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.assertions.validationfile.replacements;

import de.cronn.assertions.validationfile.normalization.ValidationNormalizer;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeReplacer
implements ValidationNormalizer {
    private static final String DATE_TIME_GROUP_NAME = "DateTime";
    private Matcher matcher;
    private DateTimeFormatter sourceFormat;
    private DateTimeFormatter destinationFormat;

    public DateTimeReplacer(Pattern pattern, DateTimeFormatter sourceFormat, DateTimeFormatter destinationFormat) {
        this.matcher = pattern.matcher("");
        this.sourceFormat = sourceFormat;
        this.destinationFormat = destinationFormat;
    }

    @Override
    public String normalize(String textToNormalize) {
        StringBuilder normalizedResultBuilder = new StringBuilder();
        this.matcher.reset(textToNormalize);
        int endOfLastMatchIndex = 0;
        boolean matchFound = false;
        while (this.matcher.find()) {
            matchFound = true;
            int startOfCurrentMatchIndex = this.matcher.start();
            int endOfCurrentMatchIndex = this.matcher.end();
            this.appendFromSourceToResult(textToNormalize, normalizedResultBuilder, endOfLastMatchIndex, startOfCurrentMatchIndex);
            String match = textToNormalize.substring(startOfCurrentMatchIndex, endOfCurrentMatchIndex);
            try {
                String possiblyDateTime = this.matchDateTime(textToNormalize);
                String formattedDateTime = this.matchDateTimeAndConvertFromSourceToDestinationFormat(possiblyDateTime);
                normalizedResultBuilder.append(match.replace(possiblyDateTime, formattedDateTime));
            }
            catch (DateTimeParseException e) {
                normalizedResultBuilder.append(match);
            }
            endOfLastMatchIndex = endOfCurrentMatchIndex;
        }
        if (!matchFound) {
            return textToNormalize;
        }
        this.appendFromSourceToResult(textToNormalize, normalizedResultBuilder, endOfLastMatchIndex, textToNormalize.length());
        return normalizedResultBuilder.toString();
    }

    private String matchDateTimeAndConvertFromSourceToDestinationFormat(String possiblyDateTime) {
        TemporalAccessor parsedDateTime = this.sourceFormat.parse(possiblyDateTime);
        return this.destinationFormat.format(parsedDateTime);
    }

    private String matchDateTime(String text) {
        return text.substring(this.matcher.start(DATE_TIME_GROUP_NAME), this.matcher.end(DATE_TIME_GROUP_NAME));
    }

    private void appendFromSourceToResult(String source, StringBuilder resultBuilder, int fromIndex, int toIndex) {
        resultBuilder.append(source, fromIndex, toIndex);
    }

    public String toString() {
        return "DateTimeReplacer for pattern " + this.matcher.pattern().toString() + ".";
    }
}

