/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.assertions.validationfile.replacements;

import de.cronn.assertions.validationfile.normalization.ValidationNormalizer;
import de.cronn.assertions.validationfile.replacements.AbstractJsonReplacer;
import de.cronn.assertions.validationfile.replacements.DateTimeReplacer;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.regex.Pattern;

public class JsonDateTimeReplacerBuilder
extends AbstractJsonReplacer<JsonDateTimeReplacerBuilder> {
    private DateTimeFormatter sourceFormat;
    private DateTimeFormatter destinationFormat;
    private String colonGroupRegex = "(\\s?:\\s?)";

    public JsonDateTimeReplacerBuilder withDestinationFormat(DateTimeFormatter destinationFormat) {
        this.destinationFormat = destinationFormat;
        return this;
    }

    public JsonDateTimeReplacerBuilder withSourceFormat(DateTimeFormatter sourceFormat) {
        this.sourceFormat = sourceFormat;
        return this;
    }

    public JsonDateTimeReplacerBuilder withColonGroupRegex(String colonGroupRegex) {
        this.colonGroupRegex = colonGroupRegex;
        return this;
    }

    @Override
    public ValidationNormalizer build() {
        Objects.requireNonNull(this.key);
        String keyWithQuotationMarks = "\"" + this.key + "\"";
        Pattern pattern = Pattern.compile(keyWithQuotationMarks + this.colonGroupRegex + "\"(?<DateTime>.+?)\"");
        return new DateTimeReplacer(pattern, this.sourceFormat, this.destinationFormat);
    }

    @Override
    protected JsonDateTimeReplacerBuilder getThis() {
        return this;
    }
}

