/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.assertions.validationfile.replacements;

import de.cronn.assertions.validationfile.normalization.ValidationNormalizer;
import de.cronn.assertions.validationfile.replacements.AbstractJsonReplacer;
import de.cronn.assertions.validationfile.replacements.Replacer;
import java.util.Objects;
import java.util.regex.Pattern;

public class JsonReplacerBuilder
extends AbstractJsonReplacer<JsonReplacerBuilder> {
    private String valueToReplace = "(null|true|false|-?\\d+(\\.\\d+)?|(\".+?(?<!\\\\)\"))";
    private String replacementValue = "[masked]";

    @Override
    public ValidationNormalizer build() {
        Objects.requireNonNull(this.key);
        Objects.requireNonNull(this.replacementValue);
        String keyWithQuotationMarks = "\"" + this.key + "\"";
        Pattern pattern = Pattern.compile(keyWithQuotationMarks + "(\\s?:\\s?)" + this.valueToReplace);
        String replacement = keyWithQuotationMarks + "$1\"" + this.replacementValue + "\"";
        return new Replacer(pattern, replacement);
    }

    @Deprecated
    public JsonReplacerBuilder withValue(String value) {
        this.valueToReplace = "\"" + value + "\"";
        return this;
    }

    public JsonReplacerBuilder withStringValue(String value) {
        this.valueToReplace = "\"" + value + "\"";
        return this;
    }

    public JsonReplacerBuilder withRawValue(String value) {
        this.valueToReplace = value;
        return this;
    }

    public JsonReplacerBuilder withReplacement(String replacement) {
        this.replacementValue = replacement;
        return this;
    }

    @Override
    protected JsonReplacerBuilder getThis() {
        return this;
    }
}

