/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.assertions.validationfile.replacements;

import de.cronn.assertions.validationfile.normalization.ValidationNormalizer;
import de.cronn.assertions.validationfile.replacements.JsonDateTimeReplacerBuilder;
import de.cronn.assertions.validationfile.replacements.JsonReplacerBuilder;
import de.cronn.assertions.validationfile.replacements.XmlDateTimeReplacerBuilder;
import de.cronn.assertions.validationfile.replacements.XmlReplacerBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Replacer
implements ValidationNormalizer {
    private final Matcher matcher;
    private final String replacement;

    public Replacer(String content, String replacement) {
        this(Pattern.compile(content), replacement);
    }

    public Replacer(Pattern pattern, String replacement) {
        this.matcher = pattern.matcher("");
        this.replacement = replacement;
    }

    @Override
    public String normalize(String source) {
        return this.matcher.reset(source).replaceAll(this.replacement);
    }

    public static XmlReplacerBuilder forXml() {
        return new XmlReplacerBuilder();
    }

    public static XmlDateTimeReplacerBuilder forXmlDateTime() {
        return new XmlDateTimeReplacerBuilder();
    }

    public static JsonReplacerBuilder forJson() {
        return new JsonReplacerBuilder();
    }

    public static JsonDateTimeReplacerBuilder forJsonDateTime() {
        return new JsonDateTimeReplacerBuilder();
    }

    public String toString() {
        return "Replacer for pattern " + this.matcher.pattern().toString() + " with replacement " + this.replacement + ".";
    }
}

