/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.assertions.validationfile.replacements;

import de.cronn.assertions.validationfile.normalization.ValidationNormalizer;
import de.cronn.assertions.validationfile.replacements.AbstractXmlReplacerBuilder;
import de.cronn.assertions.validationfile.replacements.DateTimeReplacer;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.regex.Pattern;

public class XmlDateTimeReplacerBuilder
extends AbstractXmlReplacerBuilder<XmlDateTimeReplacerBuilder> {
    private DateTimeFormatter destinationFormat;
    private DateTimeFormatter sourceFormat;
    private String dateTimePatternGroup = "(?<DateTime>.+?)";

    public XmlDateTimeReplacerBuilder withDestinationFormat(DateTimeFormatter destinationFormat) {
        this.destinationFormat = destinationFormat;
        return this;
    }

    public XmlDateTimeReplacerBuilder withSourceFormat(DateTimeFormatter sourceFormat) {
        this.sourceFormat = sourceFormat;
        return this;
    }

    private XmlDateTimeReplacerBuilder withDateTimePatternGroup(String dateTimePatternGroup) {
        this.dateTimePatternGroup = dateTimePatternGroup;
        return this;
    }

    @Override
    protected ValidationNormalizer build(String startTag, String endTag) {
        Objects.requireNonNull(this.sourceFormat);
        Objects.requireNonNull(this.destinationFormat);
        Pattern pattern = Pattern.compile(startTag + this.dateTimePatternGroup + endTag);
        return new DateTimeReplacer(pattern, this.sourceFormat, this.destinationFormat);
    }

    @Override
    protected XmlDateTimeReplacerBuilder getThis() {
        return this;
    }

    public XmlDateTimeReplacerBuilder withContent(String dateToMatch) {
        return this.withDateTimePatternGroup("(?<DateTime>" + Pattern.quote(dateToMatch) + ")");
    }
}

