/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.assertions.validationfile.replacements;

import de.cronn.assertions.validationfile.normalization.ValidationNormalizer;
import de.cronn.assertions.validationfile.replacements.AbstractXmlReplacerBuilder;
import de.cronn.assertions.validationfile.replacements.Replacer;
import java.util.Objects;
import java.util.regex.Pattern;

public class XmlReplacerBuilder
extends AbstractXmlReplacerBuilder<XmlReplacerBuilder> {
    public static final String DEFAULT_MASK = "[masked]";
    private String contentToReplace;
    private String replacementContent;

    public XmlReplacerBuilder() {
        this.withSomeContent().withReplacement(DEFAULT_MASK);
    }

    public XmlReplacerBuilder withContent(String content) {
        this.contentToReplace = content;
        return this;
    }

    public XmlReplacerBuilder withReplacement(String content) {
        this.replacementContent = content;
        return this;
    }

    public XmlReplacerBuilder withSomeContent() {
        this.contentToReplace = ".+?";
        return this;
    }

    public XmlReplacerBuilder withSomeDigitsContent() {
        this.contentToReplace = "[0-9]+";
        return this;
    }

    @Override
    protected ValidationNormalizer build(String startTag, String endTag) {
        Objects.requireNonNull(this.contentToReplace);
        Objects.requireNonNull(this.replacementContent);
        Pattern pattern = Pattern.compile(startTag + this.contentToReplace + endTag);
        String replacement = startTag + this.replacementContent + endTag;
        return new Replacer(pattern, replacement);
    }

    @Override
    protected XmlReplacerBuilder getThis() {
        return this;
    }
}

