/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.assertions.validationfile.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MarkdownTable {
    private final List<String> header = new ArrayList<String>();
    private final List<List<String>> rows = new ArrayList<List<String>>();
    private List<String> currentRow = new ArrayList<String>();

    public MarkdownTable() {
    }

    public MarkdownTable(List<String> header) {
        this.addCells(header);
        this.nextRow();
    }

    public void addCell(Object value) {
        this.currentRow.add(Objects.toString(value));
    }

    public void addCells(Collection<? extends Object> values) {
        values.forEach(this::addCell);
    }

    public void addCells(Object ... values) {
        for (Object value : values) {
            this.addCell(value);
        }
    }

    public void addRow(Collection<? extends Object> values) {
        if (!this.currentRow.isEmpty()) {
            throw new IllegalStateException("Building of the previous row is not finished. Call nextRow() first.");
        }
        this.addCells(values);
        this.nextRow();
    }

    public void addRow(Object ... values) {
        if (!this.currentRow.isEmpty()) {
            throw new IllegalStateException("Building of the previous row is not finished. Call nextRow() first.");
        }
        this.addCells(values);
        this.nextRow();
    }

    public void nextRow() {
        if (this.header.isEmpty()) {
            this.header.addAll(this.currentRow);
        } else {
            if (this.currentRow.size() != this.header.size()) {
                throw new IllegalArgumentException("Current row size [" + this.currentRow.size() + "] should be equal to header size [" + this.header.size() + "].");
            }
            this.rows.add(this.currentRow);
        }
        this.currentRow = new ArrayList<String>();
    }

    public String toString() {
        int i;
        List<Integer> maxCellLengths = this.computeColumnsWidths();
        if (maxCellLengths.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('|');
        for (i = 0; i < this.header.size(); ++i) {
            this.pad(this.header.get(i), maxCellLengths.get(i), sb);
            sb.append('|');
        }
        sb.append("\n|");
        for (i = 0; i < this.header.size(); ++i) {
            this.repeat('-', maxCellLengths.get(i) + 2, sb);
            sb.append('|');
        }
        for (List<String> row : this.rows) {
            sb.append("\n|");
            for (int i2 = 0; i2 < row.size(); ++i2) {
                this.pad(row.get(i2), maxCellLengths.get(i2), sb);
                sb.append('|');
            }
        }
        return sb.toString();
    }

    private List<Integer> computeColumnsWidths() {
        List<Integer> widths = this.header.stream().map(String::length).collect(Collectors.toList());
        for (int i = 0; i < this.header.size(); ++i) {
            for (List<String> row : this.rows) {
                widths.set(i, Math.max(row.get(i).length(), widths.get(i)));
            }
        }
        return widths;
    }

    private void repeat(char ch, int times, StringBuilder sb) {
        for (int i = 0; i < times; ++i) {
            sb.append(ch);
        }
    }

    private void pad(String value, int size, StringBuilder sb) {
        sb.append(' ');
        sb.append(value);
        this.repeat(' ', size - value.length(), sb);
        sb.append(' ');
    }
}

