/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.assertions.validationfile.util;

public final class TestNameUtils {
    private TestNameUtils() {
    }

    public static String getTestName(Class<?> aClass, String methodName) {
        return TestNameUtils.join(TestNameUtils.enclosingClassesUpstream(aClass), methodName);
    }

    private static String enclosingClassesUpstream(Class<?> aClass) {
        String classHierarchy = aClass.getSimpleName();
        for (Class<?> enclosingClass = aClass.getEnclosingClass(); enclosingClass != null; enclosingClass = enclosingClass.getEnclosingClass()) {
            classHierarchy = TestNameUtils.join(enclosingClass.getSimpleName(), classHierarchy);
        }
        return classHierarchy;
    }

    private static String join(String element, String other) {
        return other.startsWith("_") ? element + other : element + "_" + other;
    }
}

