/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.uimodel.field;

import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.uimodel.field.DynamicField;
import de.cuioss.uimodel.field.impl.BooleanEditableField;
import de.cuioss.uimodel.field.impl.DoubleEditableField;
import de.cuioss.uimodel.field.impl.FloatEditableField;
import de.cuioss.uimodel.field.impl.IntegerEditableField;
import de.cuioss.uimodel.field.impl.LongEditableField;
import de.cuioss.uimodel.field.impl.StringEditableField;
import java.io.Serializable;
import java.util.Set;
import lombok.Generated;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DynamicFieldType {
    BOOLEAN(Boolean.class, "boolean"){

        public DynamicField<Boolean> createDynamicField(Serializable value, boolean editable) {
            return new BooleanEditableField((Boolean)value, editable);
        }
    }
    ,
    STRING(String.class, "String"){

        public DynamicField<String> createDynamicField(Serializable value, boolean editable) {
            String stringValue = null;
            if (value != null) {
                stringValue = String.valueOf(value);
            }
            return new StringEditableField(stringValue, editable);
        }
    }
    ,
    INTEGER(Integer.class, "int"){

        public DynamicField<Integer> createDynamicField(Serializable value, boolean editable) {
            return new IntegerEditableField((Integer)value, editable);
        }
    }
    ,
    LONG(Long.class, "long"){

        public DynamicField<Long> createDynamicField(Serializable value, boolean editable) {
            return new LongEditableField((Long)value, editable);
        }
    }
    ,
    FLOAT(Float.class, "float"){

        public DynamicField<Float> createDynamicField(Serializable value, boolean editable) {
            return new FloatEditableField((Float)value, editable);
        }
    }
    ,
    DOUBLE(Double.class, "double"){

        public DynamicField<Double> createDynamicField(Serializable value, boolean editable) {
            return new DoubleEditableField((Double)value, editable);
        }
    };

    public static final Set<DynamicFieldType> NUMBER_SET;
    private final Class<? extends Serializable> wrapperType;
    private final String primitiveName;

    public boolean isBooleanField() {
        return BOOLEAN.equals((Object)this);
    }

    public abstract <T extends Serializable> DynamicField<T> createDynamicField(T var1, boolean var2);

    public static final DynamicFieldType getByTypeString(String type) {
        DynamicFieldType fieldType = STRING;
        for (DynamicFieldType dynamicFieldType : DynamicFieldType.values()) {
            if (!dynamicFieldType.getWrapperType().getName().equals(type) && !dynamicFieldType.primitiveName.equals(type)) continue;
            fieldType = dynamicFieldType;
            break;
        }
        return fieldType;
    }

    @Generated
    private DynamicFieldType(Class<? extends Serializable> wrapperType, String primitiveName) {
        this.wrapperType = wrapperType;
        this.primitiveName = primitiveName;
    }

    @Generated
    public Class<? extends Serializable> getWrapperType() {
        return this.wrapperType;
    }

    @Generated
    public String getPrimitiveName() {
        return this.primitiveName;
    }

    static {
        NUMBER_SET = CollectionLiterals.immutableSet((Object[])new DynamicFieldType[]{INTEGER, LONG, FLOAT, DOUBLE});
    }
}

