/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.uimodel.field.impl;

import de.cuioss.uimodel.field.DynamicField;
import de.cuioss.uimodel.field.DynamicFieldType;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;

public abstract class BaseDynamicField<T extends Serializable>
implements DynamicField<T> {
    private static final long serialVersionUID = 7865845990018198224L;
    private final boolean editable;
    private T value;
    private T oldValue;
    private boolean changed = false;
    private final DynamicFieldType fieldType;

    protected BaseDynamicField(boolean editable, DynamicFieldType fieldType) {
        this(null, editable, fieldType);
    }

    protected BaseDynamicField(T value, boolean editable, DynamicFieldType fieldType) {
        this.value = value;
        this.oldValue = value;
        this.editable = editable;
        this.fieldType = Objects.requireNonNull(fieldType);
    }

    @Override
    public void setValue(T newValue) {
        this.oldValue = this.value;
        this.value = this.checkValueIsMutable(newValue);
        this.changed = !Objects.equals(this.oldValue, this.value);
    }

    private T checkValueIsMutable(T newValue) {
        if (this.editable) {
            return newValue;
        }
        throw new IllegalStateException("Not allowed to edit value");
    }

    @Override
    public boolean isAvailable() {
        return null != this.value;
    }

    @Override
    public T resetValue() {
        this.value = this.oldValue;
        this.changed = false;
        return this.getValue();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseDynamicField)) {
            return false;
        }
        BaseDynamicField other = (BaseDynamicField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEditable() != other.isEditable()) {
            return false;
        }
        if (this.isChanged() != other.isChanged()) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        T this$oldValue = this.oldValue;
        T other$oldValue = other.oldValue;
        if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
            return false;
        }
        DynamicFieldType this$fieldType = this.getFieldType();
        DynamicFieldType other$fieldType = other.getFieldType();
        return !(this$fieldType == null ? other$fieldType != null : !((Object)((Object)this$fieldType)).equals((Object)other$fieldType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseDynamicField;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEditable() ? 79 : 97);
        result = result * 59 + (this.isChanged() ? 79 : 97);
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        T $oldValue = this.oldValue;
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        DynamicFieldType $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 43 : ((Object)((Object)$fieldType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BaseDynamicField(editable=" + this.isEditable() + ", value=" + this.getValue() + ", oldValue=" + this.oldValue + ", changed=" + this.isChanged() + ", fieldType=" + this.getFieldType() + ")";
    }

    @Override
    @Generated
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    @Generated
    public T getValue() {
        return this.value;
    }

    @Override
    @Generated
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    @Generated
    public DynamicFieldType getFieldType() {
        return this.fieldType;
    }
}

