/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.uimodel.model;

import de.cuioss.tools.string.MoreStrings;
import de.cuioss.uimodel.nameprovider.LabelKeyProvider;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum Gender implements LabelKeyProvider
{
    MALE("cui-icon-gender_male", "cui.model.gender.male.title"),
    FEMALE("cui-icon-gender_female", "cui.model.gender.female.title"),
    OTHER("cui-icon-gender_other", "cui.model.gender.other.title"),
    DIVERSE("cui-icon-gender_divers", "cui.model.gender.diverse.title"),
    UNDEFINED("cui-icon-gender_undefined", "cui.model.gender.undefined.title"),
    UNKNOWN("cui-icon-gender_unknown", "cui.model.gender.unknown.title");

    private final String cssClass;
    private final String labelKey;
    private static final Map<String, Gender> MAPPING;

    private static Map<String, Gender> initMapping() {
        HashMap<String, Gender> result = new HashMap<String, Gender>(6);
        result.put("m", MALE);
        result.put("male", MALE);
        result.put("f", FEMALE);
        result.put("female", FEMALE);
        result.put("o", OTHER);
        result.put("other", OTHER);
        result.put("d", DIVERSE);
        result.put("diverse", DIVERSE);
        result.put("x", UNDEFINED);
        result.put("undefined", UNDEFINED);
        return result;
    }

    public static final Gender fromString(String genderString) {
        String key = MoreStrings.nullToEmpty((String)genderString).toLowerCase();
        return MAPPING.getOrDefault(key, UNKNOWN);
    }

    @Generated
    private Gender(String cssClass, String labelKey) {
        this.cssClass = cssClass;
        this.labelKey = labelKey;
    }

    @Generated
    public String getCssClass() {
        return this.cssClass;
    }

    @Override
    @Generated
    public String getLabelKey() {
        return this.labelKey;
    }

    static {
        MAPPING = Gender.initMapping();
    }
}

