/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.uimodel.nameprovider;

import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.uimodel.nameprovider.IDisplayNameProvider;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;

public class I18nDisplayNameProvider
implements IDisplayNameProvider<Map<Locale, String>> {
    private static final String LOCALE_MUST_NOT_BE_NULL = "Locale must not be null.";
    private static final long serialVersionUID = 416489243142980911L;
    private final Map<Locale, String> content;
    protected final String defaultValue;

    public I18nDisplayNameProvider(String defaultValue) {
        this.content = new HashMap<Locale, String>();
        this.defaultValue = defaultValue;
    }

    public String lookupTextFor(Locale locale) {
        Preconditions.checkArgument((null != locale ? 1 : 0) != 0, (String)LOCALE_MUST_NOT_BE_NULL);
        return this.content.get(locale);
    }

    public String lookupTextWithFallbackFirstFittingLanguageOnly(Locale locale) {
        Preconditions.checkArgument((null != locale ? 1 : 0) != 0, (String)LOCALE_MUST_NOT_BE_NULL);
        for (Map.Entry<Locale, String> entry : this.content.entrySet()) {
            if (!entry.getKey().getLanguage().equals(locale.getLanguage())) continue;
            return entry.getValue();
        }
        return this.defaultValue;
    }

    @Generated
    public String toString() {
        return "I18nDisplayNameProvider(content=" + (Map)this.getContent() + ", defaultValue=" + this.defaultValue + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof I18nDisplayNameProvider)) {
            return false;
        }
        I18nDisplayNameProvider other = (I18nDisplayNameProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$content = this.getContent();
        Object other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$defaultValue = this.defaultValue;
        String other$defaultValue = other.defaultValue;
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof I18nDisplayNameProvider;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $defaultValue = this.defaultValue;
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    @Generated
    I18nDisplayNameProvider(Map<Locale, String> content, String defaultValue) {
        this.content = content;
        this.defaultValue = defaultValue;
    }

    @Override
    @Generated
    public Map<Locale, String> getContent() {
        return this.content;
    }

    public static class Builder {
        private final Map<Locale, String> collectedData;
        private String defaultValue;

        public Builder() {
            this.collectedData = new HashMap<Locale, String>();
        }

        public Builder(I18nDisplayNameProvider copyFrom) {
            this.collectedData = new HashMap<Locale, String>(copyFrom.content);
            this.defaultValue = copyFrom.defaultValue;
        }

        public Builder addAll(Map<Locale, String> data) {
            Preconditions.checkArgument((null != data ? 1 : 0) != 0, (String)"Map must not be null.");
            for (Map.Entry<Locale, String> entry : data.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder add(Locale locale, String text) {
            Preconditions.checkArgument((null != locale ? 1 : 0) != 0, (String)I18nDisplayNameProvider.LOCALE_MUST_NOT_BE_NULL);
            this.collectedData.put(locale, text);
            return this;
        }

        public Builder add(Set<Map.Entry<Locale, String>> entries) {
            Preconditions.checkArgument((null != entries ? 1 : 0) != 0, (String)"Entry must not be null.");
            for (Map.Entry<Locale, String> entry : entries) {
                this.add(entry);
            }
            return this;
        }

        public Builder add(Map.Entry<Locale, String> entry) {
            Preconditions.checkArgument((null != entry ? 1 : 0) != 0, (String)"Entry must not be null.");
            Preconditions.checkArgument((null != entry.getKey() ? 1 : 0) != 0, (String)I18nDisplayNameProvider.LOCALE_MUST_NOT_BE_NULL);
            this.collectedData.put(entry.getKey(), entry.getValue());
            return this;
        }

        public <T> Builder transformAndAddAll(Stream<T> data, Function<T, Map.Entry<Locale, String>> transormationFunction) {
            Preconditions.checkArgument((null != data ? 1 : 0) != 0, (String)"Data must not be null.");
            Preconditions.checkArgument((null != transormationFunction ? 1 : 0) != 0, (String)"Function must not be null.");
            this.add(CollectionLiterals.mutableSet(data.map(transormationFunction)));
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public I18nDisplayNameProvider build() {
            return new I18nDisplayNameProvider(this.collectedData, this.defaultValue);
        }
    }
}

