/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.uimodel.result;

import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.uimodel.result.ResultDetail;
import de.cuioss.uimodel.result.ResultObject;
import de.cuioss.uimodel.result.ResultState;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;

public class ResultOptional<T extends Serializable>
extends ResultObject<Optional<T>> {
    private static final long serialVersionUID = 4619738393641630076L;
    private final T result;

    public ResultOptional(T result, ResultState state, ResultDetail resultDetail, Enum<?> errorCode) {
        super(state, resultDetail, errorCode);
        this.result = result;
    }

    public <R extends Serializable> ResultOptional(ResultOptional<R> previousResult, Function<R, T> mapper) {
        super(previousResult.getState(), previousResult.getResultDetail().orElse(null), previousResult.getErrorCode().orElse(null));
        this.result = previousResult.isValid() && ((Optional)previousResult.getResult()).isPresent() ? (Serializable)mapper.apply(previousResult.result) : null;
    }

    public ResultOptional(T result, ResultState state) {
        this(result, state, null, null);
    }

    @Override
    public Optional<T> getResult() {
        return Optional.ofNullable(this.result);
    }

    public static <R extends Serializable> Builder<R> optionalBuilder() {
        return new Builder();
    }

    @Override
    @Generated
    public String toString() {
        return "ResultOptional(super=" + super.toString() + ", result=" + this.result + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultOptional)) {
            return false;
        }
        ResultOptional other = (ResultOptional)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        T this$result = this.result;
        T other$result = other.result;
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResultOptional;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        T $result = this.result;
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public static class Builder<S extends Serializable> {
        private static final String THE_RESULT_DETAIL_IS_MANDATORY = "The ResultDetail is mandatory if state is not VALID.";
        private static final String STATE_IS_NOT_AVAILABLE = "It make no sense to continue because state is not available!";
        private static final String ALREADY_FAILED = "Already failed: ";
        private S tempResult;
        private ResultState tempState;
        private ResultDetail tempRequestResultDetail;
        private Enum<?> tempErrorCode;

        public Builder<S> result(S result) {
            this.tempResult = result;
            return this;
        }

        public Builder<S> state(ResultState state) {
            this.tempState = Objects.requireNonNull(state, "state");
            return this;
        }

        public Builder<S> resultDetail(ResultDetail resultDetail) {
            ResultObject.logDetail(ALREADY_FAILED, this.tempState, this.tempRequestResultDetail, new CuiLogger(Builder.class));
            this.tempRequestResultDetail = resultDetail;
            return this;
        }

        public Builder<S> errorCode(Enum<?> errorCode) {
            this.tempErrorCode = errorCode;
            return this;
        }

        public Builder<S> extractStateAndDetailsAndErrorCodeFrom(ResultObject<?> previousResult) {
            Objects.requireNonNull(previousResult, "PreviousResult must not be null");
            return this.state(previousResult.getState()).resultDetail(previousResult.getResultDetail().orElse(null)).errorCode(previousResult.getErrorCode().orElse(null));
        }

        public ResultOptional<S> build() {
            if (null == this.tempState) {
                this.throwUnsupportedOperationExceptionAndSaveThePreviousError(STATE_IS_NOT_AVAILABLE);
            }
            if (!ResultState.VALID.equals((Object)this.tempState) && null == this.tempRequestResultDetail) {
                this.throwUnsupportedOperationExceptionAndSaveThePreviousError(THE_RESULT_DETAIL_IS_MANDATORY);
            }
            return new ResultOptional<S>(this.tempResult, this.tempState, this.tempRequestResultDetail, this.tempErrorCode);
        }

        private void throwUnsupportedOperationExceptionAndSaveThePreviousError(String errorMsg) {
            if (null != this.tempRequestResultDetail && this.tempRequestResultDetail.getCause().isPresent()) {
                String newErrorMsg = errorMsg + "\nThere exits additional error occurs before :";
                throw new UnsupportedOperationException(newErrorMsg, this.tempRequestResultDetail.getCause().get());
            }
            throw new UnsupportedOperationException(errorMsg);
        }
    }
}

