/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.uimodel.field.impl;

import de.cuioss.uimodel.field.TracedDynamicField;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;

public class BaseTracedDynamicField<T extends Serializable>
implements TracedDynamicField<T> {
    private static final long serialVersionUID = -5393234651696267199L;
    private final T defaultValue;
    private final boolean editable;
    private T currentValue;

    public BaseTracedDynamicField(T initialValue, boolean fieldEditable) {
        this.defaultValue = initialValue;
        this.editable = fieldEditable;
        this.resetValue();
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean isAvailable() {
        return null != this.currentValue;
    }

    @Override
    public T getValue() {
        return this.currentValue;
    }

    @Override
    public void setValue(T newValue) {
        this.currentValue = newValue;
    }

    @Override
    public boolean isChanged() {
        return !Objects.equals(this.defaultValue, this.currentValue);
    }

    @Override
    public T resetValue() {
        this.currentValue = this.defaultValue;
        return this.currentValue;
    }

    @Generated
    public String toString() {
        return "BaseTracedDynamicField(defaultValue=" + String.valueOf(this.defaultValue) + ", editable=" + this.isEditable() + ", currentValue=" + String.valueOf(this.currentValue) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseTracedDynamicField)) {
            return false;
        }
        BaseTracedDynamicField other = (BaseTracedDynamicField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEditable() != other.isEditable()) {
            return false;
        }
        T this$defaultValue = this.defaultValue;
        T other$defaultValue = other.defaultValue;
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        T this$currentValue = this.currentValue;
        T other$currentValue = other.currentValue;
        return !(this$currentValue == null ? other$currentValue != null : !this$currentValue.equals(other$currentValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseTracedDynamicField;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEditable() ? 79 : 97);
        T $defaultValue = this.defaultValue;
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        T $currentValue = this.currentValue;
        result = result * 59 + ($currentValue == null ? 43 : $currentValue.hashCode());
        return result;
    }
}

