/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.uimodel.model.conceptkey.impl;

import de.cuioss.uimodel.model.conceptkey.ConceptCategory;
import de.cuioss.uimodel.model.conceptkey.ConceptKeyType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;

public abstract class BaseConceptKeyType
implements ConceptKeyType {
    private static final long serialVersionUID = 3314726756126201321L;
    private final Set<String> aliases;
    private final Map<String, String> augmentationMap;
    private final ConceptCategory category;

    protected BaseConceptKeyType(ConceptCategory category) {
        this(new TreeSet<String>(), new HashMap<String, String>(), category);
    }

    @Override
    public String get(String key, String defaultValue) {
        if (!this.augmentationMap.containsKey(key)) {
            return defaultValue;
        }
        return this.augmentationMap.get(key);
    }

    @Override
    public String get(String key) {
        return this.get(key, null);
    }

    protected void set(String key, String value) {
        this.augmentationMap.put(key, value);
    }

    @Override
    public boolean containsKey(String key) {
        return this.augmentationMap.containsKey(key);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.augmentationMap.entrySet();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseConceptKeyType)) {
            return false;
        }
        BaseConceptKeyType other = (BaseConceptKeyType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConceptCategory this$category = this.getCategory();
        ConceptCategory other$category = other.getCategory();
        return !(this$category == null ? other$category != null : !this$category.equals(other$category));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseConceptKeyType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConceptCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BaseConceptKeyType(aliases=" + String.valueOf(this.getAliases()) + ", augmentationMap=" + String.valueOf(this.augmentationMap) + ", category=" + String.valueOf(this.getCategory()) + ")";
    }

    @Generated
    protected BaseConceptKeyType(Set<String> aliases, Map<String, String> augmentationMap, ConceptCategory category) {
        this.aliases = aliases;
        this.augmentationMap = augmentationMap;
        this.category = category;
    }

    @Override
    @Generated
    public Set<String> getAliases() {
        return this.aliases;
    }

    @Override
    @Generated
    public ConceptCategory getCategory() {
        return this.category;
    }
}

