/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.uimodel.model.conceptkey.impl;

import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.string.MoreStrings;
import de.cuioss.uimodel.model.conceptkey.ConceptCategory;
import de.cuioss.uimodel.model.conceptkey.ConceptKeyType;
import de.cuioss.uimodel.model.conceptkey.impl.BaseConceptKeyType;
import de.cuioss.uimodel.nameprovider.I18nDisplayNameProvider;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;

public class ConceptKeyTypeImpl
extends BaseConceptKeyType {
    private static final long serialVersionUID = 5225412069791405625L;
    private final String identifier;
    private final I18nDisplayNameProvider labelResolver;

    @Override
    public String getResolved(Locale locale) {
        return this.labelResolver.lookupTextWithFallbackFirstFittingLanguageOnly(locale);
    }

    ConceptKeyTypeImpl(String tempIdentifier, ConceptCategory tempCategory, Map<String, String> tempAugmentationMap, I18nDisplayNameProvider tempLabelResolver, Set<String> tempAliases) {
        super(tempAliases, tempAugmentationMap, tempCategory);
        this.identifier = tempIdentifier;
        this.labelResolver = tempLabelResolver;
    }

    public static ConceptKeyTypeImplBuilder builder() {
        return new ConceptKeyTypeImplBuilder();
    }

    @Override
    public int compareTo(ConceptKeyType other) {
        if (null != this.getCategory() && null != other.getCategory() && !this.getCategory().equals(other.getCategory())) {
            return this.getCategory().getName().compareTo(other.getCategory().getName());
        }
        return this.getIdentifier().compareTo(other.getIdentifier());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConceptKeyTypeImpl)) {
            return false;
        }
        ConceptKeyTypeImpl other = (ConceptKeyTypeImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConceptKeyTypeImpl;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ConceptKeyTypeImpl(super=" + super.toString() + ", identifier=" + this.getIdentifier() + ", labelResolver=" + String.valueOf(this.getLabelResolver()) + ")";
    }

    @Override
    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public I18nDisplayNameProvider getLabelResolver() {
        return this.labelResolver;
    }

    public static class ConceptKeyTypeImplBuilder {
        private ConceptCategory tempCategory;
        private String tempIdentifier;
        private Map<String, String> tempAugmentationMap = new HashMap<String, String>();
        private I18nDisplayNameProvider tempLabelResolver;
        private Set<String> tempAliases = new TreeSet<String>();

        ConceptKeyTypeImplBuilder() {
        }

        public ConceptKeyTypeImplBuilder identifier(String identifier) {
            this.tempIdentifier = MoreStrings.emptyToNull((String)identifier);
            return this;
        }

        public ConceptKeyTypeImplBuilder category(ConceptCategory category) {
            this.tempCategory = category;
            return this;
        }

        public ConceptKeyTypeImplBuilder labelResolver(I18nDisplayNameProvider labelResolver) {
            this.tempLabelResolver = labelResolver;
            return this;
        }

        public ConceptKeyTypeImplBuilder augmentation(Map<String, String> augmentationMap) {
            this.tempAugmentationMap.putAll(augmentationMap);
            return this;
        }

        public ConceptKeyTypeImplBuilder augmentation(String key, String value) {
            this.tempAugmentationMap.put(key, value);
            return this;
        }

        public ConceptKeyTypeImplBuilder alias(String alias) {
            this.tempAliases.add(alias);
            return this;
        }

        public ConceptKeyTypeImplBuilder alias(Set<String> aliases) {
            this.tempAliases.addAll(aliases);
            return this;
        }

        public ConceptKeyTypeImpl build() {
            Objects.requireNonNull(this.tempIdentifier, "identifier");
            Objects.requireNonNull(this.tempLabelResolver, "labelResolver");
            this.tempAugmentationMap = CollectionLiterals.immutableMap(this.tempAugmentationMap);
            this.tempAliases = CollectionLiterals.immutableSet(this.tempAliases);
            return new ConceptKeyTypeImpl(this.tempIdentifier, this.tempCategory, this.tempAugmentationMap, this.tempLabelResolver, this.tempAliases);
        }
    }
}

