/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.uimodel.nameprovider;

import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.MoreStrings;
import de.cuioss.uimodel.UiModelLogMessages;
import de.cuioss.uimodel.nameprovider.DisplayMessageProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class DisplayMessageFormat
implements Serializable {
    private static final long serialVersionUID = 1169472475051755852L;
    private final String msgKey;
    private final List<Serializable> arguments;

    public DisplayMessageFormat(String messageKey, List<Serializable> messageArguments) {
        this.msgKey = MoreStrings.requireNotEmpty((String)messageKey, (String)"messageKey");
        this.arguments = Objects.requireNonNull(messageArguments);
    }

    public DisplayMessageFormat(String messageKey, Serializable ... messageArguments) {
        this(messageKey, CollectionLiterals.immutableList((Object[])messageArguments));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String toString() {
        return "DisplayMessageFormat(msgKey=" + this.getMsgKey() + ", arguments=" + String.valueOf(this.getArguments()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisplayMessageFormat)) {
            return false;
        }
        DisplayMessageFormat other = (DisplayMessageFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$msgKey = this.getMsgKey();
        String other$msgKey = other.getMsgKey();
        if (this$msgKey == null ? other$msgKey != null : !this$msgKey.equals(other$msgKey)) {
            return false;
        }
        List<Serializable> this$arguments = this.getArguments();
        List<Serializable> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DisplayMessageFormat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $msgKey = this.getMsgKey();
        result = result * 59 + ($msgKey == null ? 43 : $msgKey.hashCode());
        List<Serializable> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    @Generated
    public String getMsgKey() {
        return this.msgKey;
    }

    @Generated
    public List<Serializable> getArguments() {
        return this.arguments;
    }

    public static class Builder {
        private static final CuiLogger LOGGER = new CuiLogger(Builder.class);
        private String tempMsgKey;
        private final List<Serializable> tempArguments = new ArrayList<Serializable>();

        public Builder(String messageKey) {
            this.tempMsgKey = MoreStrings.emptyToNull((String)messageKey);
        }

        public Builder add(Serializable ... arguments) {
            if (null != arguments) {
                this.addAll(Arrays.asList(arguments));
            }
            return this;
        }

        public Builder msgKey(String msgKey) {
            this.tempMsgKey = MoreStrings.emptyToNull((String)msgKey);
            return this;
        }

        public Builder addAll(List<Serializable> arguments) {
            if (null != arguments) {
                for (Serializable entry : arguments) {
                    if (null == entry) continue;
                    this.tempArguments.add(entry);
                }
            }
            return this;
        }

        public DisplayMessageProvider build() {
            Objects.requireNonNull(this.tempMsgKey);
            if (this.tempArguments.isEmpty()) {
                LOGGER.warn(() -> UiModelLogMessages.WARN.EMPTY_MESSAGE_ARGS.format(new Object[0]));
            }
            return new DisplayMessageProvider(new DisplayMessageFormat(this.tempMsgKey, this.tempArguments));
        }

        @Generated
        public Builder() {
        }
    }
}

