/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.uimodel.nameprovider;

import de.cuioss.uimodel.nameprovider.DisplayMessageFormat;
import de.cuioss.uimodel.nameprovider.IDisplayNameProvider;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.ResourceBundle;
import lombok.Generated;

public class DisplayMessageProvider
implements IDisplayNameProvider<DisplayMessageFormat> {
    private static final long serialVersionUID = -3453598477657055961L;
    private final DisplayMessageFormat content;

    public DisplayMessageProvider(DisplayMessageFormat displayMessageFormat) {
        this.content = Objects.requireNonNull(displayMessageFormat, "displayMessageFormat");
    }

    @Override
    public DisplayMessageFormat getContent() {
        return this.content;
    }

    public String getMessageFormated(ResourceBundle bundle) {
        Objects.requireNonNull(bundle, "bundle");
        return MessageFormat.format(bundle.getString(this.content.getMsgKey()), this.content.getArguments().toArray(new Object[this.content.getArguments().size()]));
    }

    @Generated
    public String toString() {
        return "DisplayMessageProvider(content=" + String.valueOf(this.getContent()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisplayMessageProvider)) {
            return false;
        }
        DisplayMessageProvider other = (DisplayMessageProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DisplayMessageFormat this$content = this.getContent();
        DisplayMessageFormat other$content = other.getContent();
        return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DisplayMessageProvider;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DisplayMessageFormat $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        return result;
    }

    public static class Builder {
        public DisplayMessageFormat.Builder messageKey(String messageKey) {
            return new DisplayMessageFormat.Builder(messageKey);
        }
    }
}

