/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.uimodel.result;

import de.cuioss.tools.logging.CuiLogger;

public enum ResultErrorCodes {
    NOT_FOUND,
    NOT_AUTHORIZED,
    NOT_AUTHENTICATED,
    BAD_REQUEST,
    SERVICE_NOT_AVAILABLE,
    RUNTIME_ERROR;

    private static final CuiLogger LOGGER;

    public static ResultErrorCodes parseHttpCode(int httpCode) {
        LOGGER.trace("Parsing ResultErrorCode from httpCode '%s'", new Object[]{httpCode});
        return switch (httpCode) {
            case 400 -> BAD_REQUEST;
            case 401 -> NOT_AUTHENTICATED;
            case 403 -> NOT_AUTHORIZED;
            case 404 -> NOT_FOUND;
            case 503 -> SERVICE_NOT_AVAILABLE;
            default -> RUNTIME_ERROR;
        };
    }

    static {
        LOGGER = new CuiLogger(ResultErrorCodes.class);
    }
}

