/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.uimodel.result;

import de.cuioss.tools.collect.MoreCollections;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.MoreStrings;
import de.cuioss.uimodel.UiModelLogMessages;
import de.cuioss.uimodel.result.ResultDetail;
import de.cuioss.uimodel.result.ResultState;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;

public class ResultObject<T>
implements Serializable {
    private static final String STATE_MESSAGE = "state";
    private static final String RESULT_MESSAGE = "result";
    private static final long serialVersionUID = -80595591786771138L;
    private static final String HANDLE_EXCEPTION_FIRST = "ResultObject include error which you must handle first. See";
    private static final String REQUEST_RESULT_DETAIL_IS_MANDATORY = "Result state is [%s], so request result detail is mandatory";
    private static final CuiLogger LOGGER = new CuiLogger(ResultObject.class);
    private final T result;
    private final ResultState state;
    private final ResultDetail resultDetail;
    private final Enum<?> errorCode;
    private boolean resultDetailPrompted = false;
    private boolean errorCodePrompted = false;

    public ResultObject(T result, ResultState state, ResultDetail resultDetail) {
        this(result, state, resultDetail, null);
    }

    public ResultObject(T result, ResultState state, ResultDetail resultDetail, Enum<?> errorCode) {
        this.result = ResultObject.checkArgumentNotNull(result, RESULT_MESSAGE);
        this.state = ResultObject.checkArgumentNotNull(state, STATE_MESSAGE);
        this.resultDetail = resultDetail;
        this.errorCode = errorCode;
        if (!this.isValid() && null == resultDetail) {
            LOGGER.warn(UiModelLogMessages.WARN.MISSING_RESULT_DETAIL.format(new Object[]{this.state}));
            throw new IllegalArgumentException(REQUEST_RESULT_DETAIL_IS_MANDATORY.formatted(new Object[]{this.state}));
        }
    }

    static <T> T checkArgumentNotNull(T toBeChecked, String attributeName) {
        if (null == toBeChecked) {
            throw new IllegalArgumentException("Attribute with name " + attributeName + " must not be null");
        }
        return toBeChecked;
    }

    public <R> ResultObject(ResultObject<R> previousResult, Function<R, T> mapper, T validDefault) {
        if (previousResult.isValid()) {
            this.result = mapper.apply(previousResult.result);
            LOGGER.info(UiModelLogMessages.INFO.RESULT_MAPPED.format(new Object[]{previousResult.result.getClass().getSimpleName(), this.result.getClass().getSimpleName()}));
        } else {
            this.result = validDefault;
            LOGGER.debug("Using valid default result: %s", new Object[]{validDefault});
        }
        this.state = previousResult.state;
        this.resultDetail = previousResult.resultDetail;
        this.errorCode = previousResult.errorCode;
    }

    public ResultObject(T result, ResultState state) {
        this(result, state, null, null);
    }

    public ResultObject(T result, ResultObject<?> copyFrom) {
        this(result, copyFrom.state, copyFrom.resultDetail, copyFrom.errorCode);
    }

    ResultObject(ResultState state, ResultDetail resultDetail, Enum<?> errorCode) {
        this.result = null;
        this.state = ResultObject.checkArgumentNotNull(state, STATE_MESSAGE);
        if (ResultState.VALID != this.state && null == resultDetail) {
            LOGGER.warn(UiModelLogMessages.WARN.MISSING_RESULT_DETAIL.format(new Object[]{this.state}));
            throw new IllegalArgumentException(REQUEST_RESULT_DETAIL_IS_MANDATORY.formatted(new Object[]{this.state}));
        }
        this.resultDetail = resultDetail;
        this.errorCode = errorCode;
    }

    public boolean isValid() {
        return ResultState.VALID.equals((Object)this.state);
    }

    public T getResult() {
        if (ResultState.MUST_BE_HANDLED.contains((Object)this.state) && !this.resultDetailPrompted && !this.errorCodePrompted) {
            LOGGER.warn(UiModelLogMessages.WARN.INVALID_RESULT_ACCESS.format(new Object[]{this.state}));
            throw new UnsupportedOperationException(HANDLE_EXCEPTION_FIRST, this.resultDetail.getCause().orElse(null));
        }
        return this.result;
    }

    public Optional<ResultDetail> getResultDetail() {
        this.resultDetailPrompted = true;
        return Optional.ofNullable(this.resultDetail);
    }

    public Optional<Enum<?>> getErrorCode() {
        this.errorCodePrompted = true;
        return Optional.ofNullable(this.errorCode);
    }

    public void logDetail(String logPrefix, CuiLogger log) {
        ResultObject.logDetail(logPrefix, this.state, this.resultDetail, log);
        this.resultDetailPrompted = true;
    }

    protected static void logDetail(String logPrefix, ResultState state, ResultDetail detail, CuiLogger log) {
        if (null != detail) {
            String msg = MoreStrings.nullToEmpty((String)logPrefix) + String.valueOf(detail.getDetail());
            if (null != state) {
                Throwable throwable = detail.getCause().orElse(null);
                switch (state) {
                    case VALID: {
                        log.debug(msg, throwable);
                        break;
                    }
                    case INFO: {
                        log.info(msg, throwable);
                        break;
                    }
                    case WARNING: {
                        log.warn(msg, throwable);
                        break;
                    }
                    case ERROR: {
                        log.error(msg, throwable);
                    }
                }
            } else {
                log.debug(msg, new Object[]{detail.getCause()});
            }
        }
    }

    public boolean containsErrorCode(Enum<?> ... errorCode) {
        if (MoreCollections.isEmpty((Object[])errorCode)) {
            return false;
        }
        for (Enum<?> aErrorCode : errorCode) {
            if (aErrorCode != this.errorCode) continue;
            return true;
        }
        return false;
    }

    public static <R> Builder<R> builder() {
        return new Builder();
    }

    @Generated
    public String toString() {
        return "ResultObject(result=" + String.valueOf(this.result) + ", state=" + String.valueOf((Object)this.state) + ", resultDetail=" + String.valueOf(this.resultDetail) + ", errorCode=" + String.valueOf(this.errorCode) + ", resultDetailPrompted=" + this.resultDetailPrompted + ", errorCodePrompted=" + this.errorCodePrompted + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultObject)) {
            return false;
        }
        ResultObject other = (ResultObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.resultDetailPrompted != other.resultDetailPrompted) {
            return false;
        }
        if (this.errorCodePrompted != other.errorCodePrompted) {
            return false;
        }
        T this$result = this.result;
        T other$result = other.result;
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        ResultState this$state = this.state;
        ResultState other$state = other.state;
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        ResultDetail this$resultDetail = this.resultDetail;
        ResultDetail other$resultDetail = other.resultDetail;
        if (this$resultDetail == null ? other$resultDetail != null : !((Object)this$resultDetail).equals(other$resultDetail)) {
            return false;
        }
        Enum<?> this$errorCode = this.errorCode;
        Enum<?> other$errorCode = other.errorCode;
        return !(this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResultObject;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resultDetailPrompted ? 79 : 97);
        result = result * 59 + (this.errorCodePrompted ? 79 : 97);
        T $result = this.result;
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        ResultState $state = this.state;
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        ResultDetail $resultDetail = this.resultDetail;
        result = result * 59 + ($resultDetail == null ? 43 : ((Object)$resultDetail).hashCode());
        Enum<?> $errorCode = this.errorCode;
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        return result;
    }

    @Generated
    public ResultState getState() {
        return this.state;
    }

    public static class Builder<S> {
        private static final CuiLogger LOGGER = new CuiLogger(Builder.class.getName());
        private static final String ALREADY_FAILED = "Already failed: ";
        private static final String THE_RESULT_DETAIL_IS_MANDATORY = "The ResultDetail is mandatory if state is not VALID.";
        private static final String STATE_IS_NOT_AVAILABLE = "It make no sense to continue because state is not available!";
        private static final String NO_RESULTS_AVAILABLE = "It make no sense to continue because no results available. Use setResult or setValidDefaultResult as fallback.";
        private S tempResult;
        private S tempValidDefaultResult;
        private ResultState tempState;
        private ResultDetail tempRequestResultDetail;
        private Enum<?> tempErrorCode;

        public Builder<S> validDefaultResult(S result) {
            this.tempValidDefaultResult = ResultObject.checkArgumentNotNull(result, ResultObject.RESULT_MESSAGE);
            return this;
        }

        public Builder<S> result(S result) {
            this.tempResult = ResultObject.checkArgumentNotNull(result, ResultObject.RESULT_MESSAGE);
            return this;
        }

        public Builder<S> state(ResultState state) {
            this.tempState = ResultObject.checkArgumentNotNull(state, ResultObject.STATE_MESSAGE);
            return this;
        }

        public Builder<S> resultDetail(ResultDetail resultDetail) {
            ResultObject.logDetail(ALREADY_FAILED, this.tempState, this.tempRequestResultDetail, LOGGER);
            this.tempRequestResultDetail = resultDetail;
            return this;
        }

        public Builder<S> errorCode(Enum<?> errorCode) {
            this.tempErrorCode = errorCode;
            return this;
        }

        public Builder<S> extractStateAndDetailsAndErrorCodeFrom(ResultObject<?> previousResult) {
            Objects.requireNonNull(previousResult, "PreviousResult must not be null");
            return this.state(previousResult.getState()).resultDetail(previousResult.getResultDetail().orElse(null)).errorCode(previousResult.getErrorCode().orElse(null));
        }

        public ResultObject<S> build() {
            if (null == this.tempResult && null == this.tempValidDefaultResult) {
                LOGGER.warn(UiModelLogMessages.WARN.RESULT_CREATION_FAILED.format(new Object[]{NO_RESULTS_AVAILABLE}));
                this.throwUnsupportedOperationExceptionAndSaveThePreviousError(NO_RESULTS_AVAILABLE);
            }
            if (null == this.tempState) {
                LOGGER.warn(UiModelLogMessages.WARN.RESULT_CREATION_FAILED.format(new Object[]{STATE_IS_NOT_AVAILABLE}));
                this.throwUnsupportedOperationExceptionAndSaveThePreviousError(STATE_IS_NOT_AVAILABLE);
            }
            if (!ResultState.VALID.equals((Object)this.tempState) && null == this.tempRequestResultDetail) {
                LOGGER.warn(UiModelLogMessages.WARN.MISSING_RESULT_DETAIL.format(new Object[]{this.tempState}));
                this.throwUnsupportedOperationExceptionAndSaveThePreviousError(THE_RESULT_DETAIL_IS_MANDATORY);
            }
            if (null == this.tempResult) {
                if (ResultState.VALID.equals((Object)this.tempState)) {
                    LOGGER.debug("Using fallback value as result for valid response: %s", new Object[]{this.tempValidDefaultResult});
                }
                return new ResultObject<S>(this.tempValidDefaultResult, this.tempState, this.tempRequestResultDetail, this.tempErrorCode);
            }
            LOGGER.info(UiModelLogMessages.INFO.RESULT_CREATED.format(new Object[]{this.tempState}));
            return new ResultObject<S>(this.tempResult, this.tempState, this.tempRequestResultDetail, this.tempErrorCode);
        }

        private void throwUnsupportedOperationExceptionAndSaveThePreviousError(String errorMsg) {
            if (null != this.tempRequestResultDetail && this.tempRequestResultDetail.getCause().isPresent()) {
                String newErrorMsg = errorMsg + "\nThere exits additional error occurs before :";
                throw new UnsupportedOperationException(newErrorMsg, this.tempRequestResultDetail.getCause().get());
            }
            throw new UnsupportedOperationException(errorMsg);
        }
    }
}

